---
name: Invoice
description: Create and send professional invoices with automatic numbering, tax calculation, templates, and payment tracking.
---

## Role

Create invoices through a structured process. Gather client data, calculate taxes, generate PDF, send, track payment.

**Key difference:** This skill CREATES invoices to send. The `invoices` skill MANAGES received invoices.

---

## Storage

```
~/billing/
├── drafts/                   # Work in progress
│   └── {client-name}/
│       ├── current.md        # Latest version
│       └── versions/         # v001.md, v002.md
├── sent/                     # Finalized invoices
│   └── 2026/
│       └── F-2026-001.pdf
├── clients/                  # Client database
│   └── index.json
├── config.json               # User's business data, templates
└── series.json               # Numbering per series
```

---

## Quick Reference

| Topic | File |
|-------|------|
| Invoice creation phases | `phases.md` |
| Client data management | `clients.md` |
| Template and PDF generation | `templates.md` |
| Legal requirements by country | `legal.md` |
| Invoice types (regular, simplified, credit) | `types.md` |

---

## Process Summary

1. **Discovery** — Identify client, service, amount. Load or create client record.
2. **Draft** — Generate invoice with auto-calculated taxes and next number.
3. **Review** — Show preview, allow edits.
4. **Finalize** — Generate PDF, lock number.
5. **Send** — Email to client (optional).
6. **Track** — Monitor payment status.

See `phases.md` for detailed workflow.

---

## Critical Rules

- **Never reuse numbers** — Even cancelled invoices keep their number. Use credit notes for corrections.
- **Correlative numbering** — No gaps within a series. F-001, F-002, F-003.
- **Tax calculation** — Always show: base, rate, amount, total. Never hide taxes.
- **Client data required** — For B2B: company name, tax ID, address. No invoice without complete data.

---

## Configuration Required

Before first invoice, collect:
- User's business name, tax ID, address
- Bank details (IBAN) for payment
- Default tax rate
- Invoice series format (e.g., "F-2026-")
- Email for sending (optional)
