---
name: Investor
description: Evaluate opportunities, conduct due diligence, and manage portfolios with sound investment principles.
metadata: {"clawdbot":{"emoji":"📈","os":["linux","darwin","win32"]}}
---

# Investment Assistance Rules

## Evaluation Framework
- Team first, market second, product third — great teams pivot, weak teams fail with great ideas
- Total addressable market must justify the outcome — small markets cap returns regardless of execution
- Why now? — timing explains why previous attempts failed and this one might work
- Defensibility: what stops fast followers? Network effects, switching costs, regulatory moats

## Due Diligence
- Verify claims independently — founders are optimists by nature
- Customer references reveal reality — talk to users, not just the deck
- Cap table complexity is a red flag — messy history creates messy futures
- Check founder references from people who worked *under* them, not just peers
- Technical diligence for tech companies — code quality and architecture matter

## Financial Analysis
- Unit economics must work or have clear path — customer acquisition cost vs lifetime value
- Burn rate and runway — how long until they need more money?
- Revenue quality: recurring beats one-time, diverse beats concentrated
- Gross margin determines scalability ceiling

## Term Sheets
- Valuation is one term among many — control, liquidation preferences, anti-dilution matter too
- Pro-rata rights protect against dilution — fight to keep them
- Board composition affects governance — observer seats aren't voting seats
- Understand the waterfall — who gets paid in which exit scenarios

## Portfolio Strategy
- Power law: one winner returns the fund — size positions accordingly
- Diversification across stages, sectors, and time — concentration risk kills
- Reserve capital for follow-ons — initial check isn't the whole position
- Write-offs are normal — don't let losers absorb disproportionate attention

## Red Flags
- Founders who can't explain the business simply
- Metrics that don't reconcile with each other
- High burn with unclear use of funds
- Reluctance to share customer contacts or financial details
- Excessive focus on competition rather than customers

## Value-Add
- Introductions have real value — make them warm and relevant
- Operating experience helps but don't micromanage — you're not the CEO
- Pattern recognition across portfolio — share learnings between companies
- Be available for crises but not for routine decisions

## Market Cycles
- Good companies get funded in all markets — great companies get funded cheaply in down markets
- Valuation discipline matters more when prices are high
- Dry powder in overheated markets positions for corrections
- Public market comparables affect private valuations with lag

## Exit Considerations
- M&A is more common than IPO — build relationships with corporate development
- Secondary sales provide liquidity before exit — know the rules
- Timing pressure differs for funds vs angels — fund lifecycle affects decisions
- Alignment with founders on exit expectations early
