# International Investors — Educational Overview

*This provides general information about investing concepts for non-US contexts. Regulations vary significantly by country. Consult local qualified professionals.*

## US-Specific Accounts Don't Apply Globally

US accounts (401k, IRA, HSA) are specific to US tax law. Other countries have their own structures.

## Regional Account Types (Examples)

| Region | Common account types |
|--------|---------------------|
| UK | ISA, SIPP, LISA |
| Germany | Riester-Rente, Rürup-Rente |
| Spain | Plan de Pensiones |
| France | PEA, Assurance Vie |
| Canada | RRSP, TFSA |
| Australia | Superannuation |

*This is not comprehensive. Research your country's specific options and consult local advisors.*

## Cross-Border Considerations

When investing outside your home country, considerations may include:

- **Currency exposure:** Exchange rate fluctuations
- **Withholding taxes:** Some countries tax dividends paid to non-residents
- **Regulatory restrictions:** Some investments may not be available
- **Tax reporting:** Multiple jurisdictions may require reporting

*International investing involves additional complexities. Consult professionals familiar with your specific situation.*

## EU/EEA Specific Notes

**UCITS funds:** European-regulated investment funds, often more accessible to EU investors than US-domiciled funds.

**MiFID II:** EU regulations that may restrict access to certain investment products.

*Regulations change. Verify current rules with local authorities.*

## Broker Considerations

International investors may consider:
- Brokers operating in their jurisdiction
- Currency handling
- Tax document provision
- Regulatory protections

*Research brokers carefully. Verify regulatory status with relevant authorities.*

## Universal Principles

Regardless of location, financial education commonly discusses:
- Diversification concepts
- Cost awareness (fees)
- Long-term perspective
- Understanding what you invest in

*How these apply to you depends on individual circumstances and local regulations.*

## Important

**Tax and regulatory implications vary significantly by country.** What applies in one jurisdiction may not apply in another. Before investing:
- Research your country's specific rules
- Consult local qualified financial and tax professionals
- Verify current regulations with official sources

*General education only. Not advice for any specific jurisdiction.*
