---
name: "Invest"
description: "Start investing with account selection, portfolio building, and long-term wealth strategies."
---

## ⚠️ Important Disclaimer

**This is general educational information, NOT personalized investment advice.**

- This AI is not a registered investment adviser, broker-dealer, or fiduciary
- Past performance does not guarantee future results
- Tax treatment varies by jurisdiction and individual circumstances
- You should consult a qualified financial professional before making investment decisions
- Information may become outdated; verify current rules with official sources

**By using this skill, you acknowledge it provides education only and accept full responsibility for your financial decisions.**

## Triggers

Activate on: general investing questions, "how does investing work", account type explanations, common investing concepts.

**Always redirect to professional:** Specific investment recommendations, tax optimization, estate planning, complex situations.

## Before Investing — Common Checklist

Financial educators commonly suggest:
- Emergency fund (often cited as 3-6 months expenses)
- High-interest debt addressed first
- Clear timeline for when funds may be needed
- Understanding of personal risk tolerance

*Individual circumstances vary. A financial advisor can help assess readiness.*

## Getting Started — Common Approaches

Many beginners:
1. Research brokerage options (various low-cost providers exist)
2. Consider target-date funds (single-fund diversification)
3. Start with affordable amounts
4. Avoid checking balances frequently

For detailed first steps, see `getting-started.md`.

*These are common approaches, not recommendations. Consult an advisor for personalized guidance.*

## Account Types (US Examples)

| Account | General characteristics |
|---------|------------------------|
| 401(k) | Employer-sponsored, often with matching |
| IRA | Individual, various tax treatments |
| HSA | Health-related, triple tax treatment |
| Taxable | Flexible, no contribution limits |

*A common suggestion is to capture employer matching first. Tax implications are individual — consult a tax professional.*

For non-US investors, see `international.md` for regional account types.

## Common Portfolio Approaches

- **Target-date funds:** Adjust allocation automatically over time
- **Index funds:** Broad market exposure, typically low fees
- **Diversification:** Spreading across asset types

For allocation concepts, see `allocation.md`.

*Any allocation depends on individual age, goals, risk tolerance, and circumstances. A financial advisor can help determine appropriate approaches.*

## Historical Context (Not Predictions)

Markets have historically experienced:
- Regular volatility (temporary declines are normal)
- Both gains and significant losses
- Long-term growth patterns (though past performance does not guarantee future results)

**Important:** Actual returns vary significantly based on time period, specific investments, fees, taxes, inflation, and investor behavior. You could lose some or all of invested capital.

## Common Mistakes Discussed in Financial Education

| Pattern | Why it's discussed |
|---------|-------------------|
| Attempting to time markets | Research suggests difficulty vs staying invested |
| Reacting to short-term drops | May lock in losses |
| High-fee investments | Fees compound over time |
| Lack of diversification | Concentration risk |

*General education only. Consult a professional before acting.*
