# Inversion Framework - Detailed Methodology

## The Munger Method

Charlie Munger (Warren Buffett's partner) lives by inversion:

"All I want to know is where I'm going to die, so I'll never go there."

Applied to business:
- Don't ask "How do I build a great company?"
- Ask "What destroys companies?" → Then don't do those things

## Categories of Failure

### Type 1: Single-Point Failures
One thing goes wrong → entire project fails
- Key person leaves
- Single customer churns
- Regulatory change
- Technical system failure

**Inversion Strategy:** Eliminate single points of failure

### Type 2: Slow Decay Failures
Gradual erosion you don't notice
- Culture drift
- Quality decline
- Customer satisfaction erosion
- Technical debt accumulation

**Inversion Strategy:** Build measurement systems, regular audits

### Type 3: Self-Inflicted Failures
You cause your own downfall
- Overconfidence
- Moving too fast
- Ignoring feedback
- Misaligned incentives

**Inversion Strategy:** Humility, feedback loops, incentive audits

### Type 4: External Shock Failures
Things outside your control
- Market crash
- Pandemic
- Competitor breakthrough
- Regulatory change

**Inversion Strategy:** Build resilience, maintain reserves, diversify

## Inversion Questions by Domain

### Product Development
- What would make users HATE this?
- What would make this impossible to use?
- What would make people uninstall immediately?

### Business Strategy
- What would bankrupt us?
- What would make customers leave en masse?
- What would make talent refuse to work here?

### Relationships/Partnerships
- What would destroy this partnership?
- What would make them never trust us again?
- What would turn allies into enemies?

### Personal Productivity
- What would guarantee I waste this day?
- What would make me miss this deadline?
- What would ensure I never finish this project?

## The Anti-Checklist Concept

Atul Gawande's "Checklist Manifesto" shows checklists save lives.

But ANTI-checklists might be more powerful:

**Regular Checklist:** "Do X, Y, Z"
**Anti-Checklist:** "Never do A, B, C"

The anti-checklist catches you BEFORE mistakes.

### Structure
```
BEFORE LAUNCH, VERIFY NONE OF THESE:
□ Single point of failure exists
□ No rollback plan
□ Untested with real users
□ No monitoring/alerting
□ Team unclear on ownership
```

## Integration with Other Skills

- **First Principles**: After decomposing, invert to find risks
- **Second-Order**: Invert the consequences - what if reactions are negative?
- **Pre-Mortem**: Inversion applied specifically to project planning
- **Six Hats**: Black Hat thinking is essentially inversion

## Advanced: Double Inversion

1. State goal: "Launch successful app"
2. First inversion: "What would make app fail?"
3. Answer: "Poor user experience"
4. Second inversion: "What would make UX amazing?"
5. Answer: "Obsessive user testing, fast iteration"

Double inversion often reveals more actionable insights.
