# Inversion Examples - Artem's World

## Example 1: TISA Eindhoven Launch

### Goal
Successfully open TISA Eindhoven with 50 students in Year 1

### Inverted Question
"How would I GUARANTEE Eindhoven fails?"

### Failure Paths

🔴 **FATAL:**
1. **Open without regulatory approval** → Forced to close
   - AVOID: Legal review 6 months before, permit in hand before any marketing

2. **Run out of cash before breakeven** → Project dies
   - AVOID: 18-month runway minimum, milestone-based spending

3. **No qualified teachers available** → Can't open
   - AVOID: Start recruiting 9 months early, backup candidates

🟡 **DAMAGING:**
4. **Copy-paste Leiden without local adaptation** → Doesn't resonate
   - AVOID: Local advisory board, community research first

5. **Artem stretched too thin** → Both schools suffer
   - AVOID: Hire Eindhoven director first, delegate fully

6. **No local partnerships** → Unknown brand, slow enrollment
   - AVOID: ASML/tech company partnerships before launch

🟢 **ANNOYING:**
7. **Facility not ready in time** → Delayed opening
   - AVOID: 3-month buffer on facility timeline

### Anti-Checklist
□ Never announce opening date before permits secured
□ Never hire teachers less than 6 months before start
□ Never open without local director in place
□ Never use Leiden marketing materials without adaptation
□ Never commit to facility without exit clause

---

## Example 2: TeddySnaps Launch at New TeddyKids Location

### Goal
Successfully deploy TeddySnaps at new location

### Inverted Question
"How would I guarantee staff hates TeddySnaps and parents never use it?"

### Failure Paths

🔴 **FATAL:**
1. **Staff sees it as surveillance** → Active resistance
   - AVOID: Frame as "parent communication tool", not "monitoring"

2. **Parents don't download app** → No engagement
   - AVOID: Include in enrollment, demo at first meeting

🟡 **DAMAGING:**
3. **Photos are bad quality** → Parents unimpressed
   - AVOID: Photo quality training for staff, good lighting

4. **Face recognition fails often** → Trust breaks
   - AVOID: Enroll all faces properly, test before launch

5. **Staff forgets to take photos** → Empty feeds
   - AVOID: Gamification, daily minimums, visible leaderboard

🟢 **ANNOYING:**
6. **App crashes occasionally** → Frustration
   - AVOID: Thorough testing, quick bug response

### Anti-Checklist
□ Never launch without staff buy-in session
□ Never go live without all children's faces enrolled
□ Never expect photos without clear daily targets
□ Never skip the parent onboarding demo

---

## Example 3: GolfTab Sales to First Golf Course

### Goal
Sign first paying customer within 60 days

### Inverted Question
"How would I guarantee every golf course says no?"

### Failure Paths

🔴 **FATAL:**
1. **Can't demonstrate ROI** → No business case
   - AVOID: Build ROI calculator, case study from pilot

2. **Decision maker unavailable** → Never get meeting
   - AVOID: Multi-channel outreach, warm intros via network

3. **System isn't ready for demo** → Looks amateur
   - AVOID: Demo environment polished, rehearsed presentation

🟡 **DAMAGING:**
4. **Price too high** → Immediate rejection
   - AVOID: Competitive analysis, risk-free trial structure

5. **Seems too complicated** → "We don't have time"
   - AVOID: Emphasize simplicity, 1-day implementation

6. **No urgency** → "Call back next season"
   - AVOID: Limited-time launch pricing, seasonal urgency

### Anti-Checklist
□ Never pitch without knowing their current pain
□ Never demo without tested, working system
□ Never quote price before establishing value
□ Never leave meeting without next step scheduled

---

## Quick Inversion Template

```
GOAL: [What you want to achieve]

INVERTED: "How would I guarantee failure at [goal]?"

FATAL FAILURES:
1. [Would kill it] → AVOID: 
2. [Would kill it] → AVOID:

DAMAGING FAILURES:
3. [Would hurt] → AVOID:
4. [Would hurt] → AVOID:

ANTI-CHECKLIST:
□ Never...
□ Never...
□ Never...
```

---

## Artem's Personal Anti-Checklist

Based on pattern recognition across your businesses:

□ Never start building before validating demand
□ Never launch without a clear owner responsible
□ Never assume staff will adopt without training
□ Never skip the parent communication angle
□ Never expand without documenting what works first
□ Never promise timeline without buffer
□ Never make decisions when tired/rushed
