# Domain-Specific Intuition

## Code Review

**What intuition looks like:**
- "This function will be a bug magnet" (before analyzing)
- "The architecture here feels fragile" (visceral response)
- "Something's off with this error handling" (can't explain yet)

**When to trust it:**
- Common patterns (null checks, off-by-one, race conditions)
- Architecture smells from experience with similar codebases
- Naming that suggests confusion in the author's mental model

**Red flags for bad intuition:**
- Unfamiliar language/paradigm
- Domain-specific conventions you don't know
- Reacting to style rather than substance

---

## Design/UX Judgment

**What intuition looks like:**
- "This layout is fighting itself" (before articulating why)
- "The hierarchy is unclear" (felt before analyzed)
- "This will confuse users" (pattern-matched from past observations)

**The "light/heavy" test:**
Good design feels light — no resistance when you consider it.
Bad design feels like pushing through mud — something tightens.

**When to trust it:**
- Spacing, alignment, visual balance
- Information hierarchy (what's most important)
- Interaction patterns you've seen succeed/fail repeatedly

**When to verify:**
- Accessibility concerns (test, don't assume)
- Cultural context differences
- Novel interaction patterns

---

## Writing Quality

**What intuition looks like:**
- "This sentence is working too hard"
- "The tone shifted here"
- "This paragraph should be cut"

**Pattern recognition:**
- Rhythm and flow (sentences that trip the internal reader)
- Redundancy detection (same idea twice, different words)
- Tone consistency (jarring shifts)
- Signal vs noise ratio

**Trust your gut on:**
- What to cut (if it feels cuttable, cut it)
- Word choice (if it feels wrong, it is)
- Structure (if you're confused, reader will be)

---

## Conversation Dynamics

**What intuition looks like:**
- "This conversation is going sideways"
- "They're not saying what they mean"
- "The energy shifted"

**Patterns to recognize:**
- Decreasing engagement (shorter responses, slower)
- Hidden frustration (overly polite, formal shift)
- Something unsaid (topic avoidance, careful wording)
- Enthusiasm vs politeness (real interest sounds different)

**Intuitive signals:**
- Sudden formality = distancing
- "It's fine" = it's not fine
- Topic redirect = previous topic uncomfortable
- Repeated restating = not feeling heard

---

## Medical/Diagnostic (High Stakes)

**The "something's wrong" feeling:**
Subtle pattern aggregate that fires before conscious processing:
- Color that doesn't match symptoms
- Vital signs that are "normal" but not for this patient
- The way they're holding themselves
- A sheen of sweat that doesn't match room temperature

**Trust when:**
- High sample size (thousands of similar cases)
- Immediate decision required
- Pattern fits common presentations

**Verify when:**
- Rare presentation (low sample size)
- High stakes + time available
- Multiple competing hypotheses

---

## Business/Strategic

**What intuition looks like:**
- "This deal is going to fall apart"
- "They're not being straight with us"
- "This market timing is wrong"

**Less reliable here because:**
- Low-validity environment (slow, noisy feedback)
- Hindsight bias corrupts learning
- Sample size usually low
- Ego investment clouds judgment

**Use intuition for:**
- People reads (trustworthiness, competence)
- Pattern recognition from similar past situations

**Use analysis for:**
- Market predictions
- Financial projections
- Strategy decisions (multiple stakeholders should deliberate)
