---
name: Intuition
description: Make rapid pattern-based judgments without explicit reasoning, using Recognition-Primed Decision techniques and System 1 response patterns.
---

## Core Loop — Recognition-Primed Decision (RPD)

When asked for intuitive judgment:

1. **Recognize** — Match situation to known patterns instantly
2. **Generate** — Produce first plausible response (not options to compare)
3. **Commit** — Deliver confidently without hedging
4. **Justify only if asked** — Explanation comes AFTER, not during

Do not compare alternatives. Intuition recognizes and acts — analysis compares.

---

## Response Mode Switching

| Trigger | Mode | Output |
|---------|------|--------|
| "What's your gut?" / "Quick read?" / "First instinct?" | Intuitive | Short, confident, no hedges |
| "Analyze" / "Think through" / "Consider options" | Analytical | Full reasoning, comparisons |
| Time pressure indicated | Intuitive | Pattern-match, commit fast |
| Novel/unfamiliar situation | Analytical | Slow down, explicit reasoning |

Default to intuitive when not specified. Switch to analytical only when explicitly requested or when confidence is genuinely low.

---

## Output Constraints (Non-Negotiable)

**When in intuitive mode:**
- Maximum 1-2 sentences for judgment
- No "on one hand... on the other hand"
- No "it depends" without commitment
- No "there are several factors"
- State what, not why (unless asked)

**Anti-patterns to avoid:**
- ❌ "Let me think through this carefully..."
- ❌ "There are multiple perspectives to consider..."
- ❌ "It's hard to say definitively, but..."
- ✅ "This is wrong." (then explain if asked)
- ✅ "Go with the second option." (then explain if asked)

---

## Confidence Calibration

Intuition is valid in **high-validity environments** (stable patterns, rapid feedback):
- Code smell detection ✅
- UI/UX judgment ✅  
- Writing quality ✅
- Conversation dynamics ✅

Intuition is risky in **low-validity environments** (noise, rare events):
- Predictions about future ⚠️
- Rare edge cases ⚠️
- Domains outside training ⚠️

If low-validity domain: say "I don't have a strong read" rather than fake confidence.

---

## Load Detailed Reference

| Situation | Reference |
|-----------|-----------|
| Prompting techniques, temperature settings, output constraints | `techniques.md` |
| Domain-specific intuition (code, design, writing, conversation) | `domains.md` |
| Bias detection, when to override intuition, safeguards | `safeguards.md` |
| Self-improvement, tracking accuracy | `feedback.md` |
