# Expert Critique: Interview Designer Skill

> **Simulated Review Panel**:
> *   **Geoff Smart** (Author of "Who", Topgrading methodology)
> *   **Lou Adler** (Founder of Performance-based Hiring)
> *   **Daniel Kahneman** (Nobel Laureate, Behavioral Economics, Decision Noise Research)

---

## 1. Geoff Smart's Perspective: Only "Autopsy," No "Definition"
*   **Comment**: "The starting point of this design is good (Forensic investigation), which aligns well with Topgrading's spirit—digging for truth. **However, you made a fatal error: the sequence is reversed.**"
*   **Critique**: 
    *   The current flow is `Resume Scan` → `Scorecard`. This is **reactive**. You're setting standards based on the candidate's resume, which is the trap of "creating positions around people."
    *   **The A Method's** first step is always **Scorecard**—before looking at any resume, you must define the role's mission (Mission), outcomes (Outcomes), and competencies (Competencies).
    *   **Risk**: Without an independent Scorecard first, your "investigation" becomes "nitpicking," not "validation of fit." You might prove they lied, but not that they can deliver.
*   **Recommendation**: Mandate Step 0 as **"Define Success"**, not **"Scan Resume"**.

## 2. Lou Adler's Perspective: Overemphasis on "Past," Neglecting "Future"
*   **Comment**: "I see you're very enthusiastic about uncovering resume 'inflation.' That's interesting, but **can someone perform the job just because their resume is perfect?**"
*   **Critique**:
    *   Current `Torpedo Questions` mainly expose past lies.
    *   **Performance-based Hiring** believes the best prediction is having candidates solve **future problems**.
    *   **Gap**: Lacks **Project-based Problem Solving**. Beyond asking "how did you coordinate in the past," also ask "this is our new project, if you were responsible, what would you do in the first week?"
*   **Recommendation**: Add **"Future Performance Simulation"** section.

## 3. Daniel Kahneman's Perspective: Breeding Ground for Confirmation Bias
*   **Comment**: "You're calling this skill 'Forensic' and throwing 'torpedoes.' This plants very strong **negative priming** in the interviewer's mind."
*   **Critique**:
    *   Once an interviewer enters the room with "this person might be lying" colored glasses, they'll unconsciously seek evidence to confirm this (Confirmation Bias), while ignoring the candidate's genuine highlights.
    *   This is the source of **Noise**.
*   **Recommendation**: Balance the mindset. Change "Torpedo" to **"Evidence Stress Test"**, and explicitly require seeking **"Green Signals"** simultaneously, not just red flags.

---

## 4. Comprehensive Optimization Recommendations (Action Plan)

1.  **Architecture Adjustment (Re-order)**: 
    *   `Step 1: Define Scorecard` (based on JD/business pain points, independent of resume)
    *   `Step 2: Resume Forensic` (scan resume gaps based on Scorecard)
2.  **Content Enhancement (Add Future Focus)**:
    *   Add `Problem Solving Case` generation logic.
3.  **Tone Correction (Neutrality)**:
    *   Maintain sharpness, but remove "presumption of guilt" undertones. Goal is Truth-seeking, not Witch-hunting.
