---
name: internet-failure-analysis-expert
description: 对各类故障进行系统性分析，支持CVE漏洞和互联网故障两种模式，包括获取官方报告、拆解时间线、分析导火索和连环故障、识别根本原因（人、组织因素）以及提供技术改进建议，最终生成完整分析报告
dependency:
  python:
    - requests>=2.31.0
    - beautifulsoup4>=4.12.0
---

# 故障分析专家（CVE漏洞 & 互联网故障）

## 任务目标
- 本Skill用于：对各类故障进行深度分析，支持两种输入模式
- 能力包含：
  - 自动识别输入类型（CVE编号 / 互联网故障描述）
  - 获取官方故障报告作为ground truth
  - 拆解故障时间线和关键事件节点
  - 分析导火索、初始问题及引发的连环故障
  - 识别根本原因（人员因素、组织架构因素）
  - 提供技术改进建议
- 触发条件：
  - CVE编号模式：用户提供CVE编号（如CVE-2021-44228）
  - 通用模式：用户提供故障描述、关键词、事件名称

## 前置准备
- 依赖说明：
  ```
  requests>=2.31.0
  beautifulsoup4>=4.12.0
  ```
- 无需额外文件准备

## 操作步骤

### 步骤1：识别输入类型并获取官方数据

智能体首先判断用户输入类型，选择相应的处理流程：

#### 模式A：CVE编号（输入以"CVE-"开头）
调用 `scripts/fetch_cve_data.py` 获取官方数据：
- 输入：CVE编号（格式如 "CVE-2021-44228"）
- 输出：包含以下信息的结构化数据（JSON格式）：
  - CVE ID
  - 描述（中文和英文）
  - CVSS评分（v3.1/v2.0）
  - 严重性等级
  - 发布日期、修改日期
  - 影响产品/厂商、受影响版本
  - 参考资料（官方公告、漏洞详情等URL）
  - 漏洞类型（CWE）
  - 利用复杂度、权限要求等元数据
  - **官方公告内容**（脚本自动爬取发布方官方公告的完整文本）

#### 模式B：互联网故障描述（任意故障描述）
智能体执行以下子步骤：

**步骤1.1：搜索故障报道**
- 构建多个搜索查询：
  - 核心关键词 + "故障报告"
  - 核心关键词 + "incident report"
  - 核心关键词 + "post-mortem"
  - 核心关键词 + "官方声明"
- 搜索源包括：官方博客、技术博客、新闻媒体、技术社区

**步骤1.2：定位并获取官方故障报告**
- 识别官方来源（公司/组织官方博客、官方GitHub、技术社区公告）
- 识别报告特征（详细技术细节、时间线描述、根因分析）
- 对识别的官方报告URL，调用 `scripts/extract_webpage.py` 提取完整文本
- 优先提取最详细、最权威的报告

**步骤1.3：输出官方报告内容**
- 官方报告的完整文本内容
- 报告来源和发布时间
- 报告的关键信息摘要

### 步骤2：基于官方报告拆解故障时间线和事件节点
**以官方故障报告为主要依据**，智能体将分析并输出：

**时间线要素**：
- 故障发现时间
- 故障首次影响用户的时间
- 问题报告和确认时间
- 故障扩散和升级过程
- 应急响应和修复时间点
- 服务完全恢复时间
- 关键决策和行动时间点

**时间线格式**：
```
时间 | 事件 | 影响 | 响应行动
```

**分析要点**：
- 识别关键转折点（从轻微到严重的变化）
- 标记响应速度（MTTD、MTTR）
- 记录影响范围变化
- 识别决策延迟点

### 步骤3：基于官方报告分析导火索和连环故障
**以官方报告技术细节为依据**，智能体将分析：

**导火索识别**（从官方报告提取）：
- 触发故障的初始条件（配置变更、部署发布、流量激增、外部依赖故障、特定输入等）
- 第一个出现的问题（代码bug、配置错误、资源耗尽、网络故障、设计缺陷等）
- 触发路径（谁/什么/何时/如何触发的）

**连环故障分析**（基于官方报告的故障传播描述）：
- 初始问题如何扩散到其他系统
- 级联故障路径（A系统故障 → B系统受影响 → C系统崩溃）
- 放大因子（缓存雪崩、重试风暴、单点故障传播、权限提升、数据泄露等）
- 雪崩效应（一个组件故障如何导致系统整体不可用）

**输出结构**：
- 导火索：清晰描述触发条件和触发路径（引用官方报告）
- 故障链：按顺序列出故障传播路径（引用官方报告）
- 放大因子：识别导致故障扩大的机制

### 步骤4：基于官方报告识别根本原因
**结合官方报告的根因分析章节**，从两个维度深入分析：

**人员因素**（从官方报告的"Root Cause"章节提取）：
- 开发/运维人员的技术盲区或认知偏差
- 代码审查过程中的疏漏
- 安全意识不足
- 测试覆盖不全
- 操作失误（误操作、配置错误）
- 沟通不畅（信息传递延误或失真）

**组织架构因素**（从官方报告的"Lessons Learned"推断）：
- 开发流程缺陷（缺乏自动化测试、灰度发布机制）
- 资源分配问题（监控投入不足、应急演练缺失）
- 责任划分不清（故障响应时权责不明）
- 响应机制不完善（缺乏应急预案、响应流程混乱）
- 文档和知识管理缺失（关键信息未文档化）
- 供应商依赖和管理问题（第三方SLA不足）
- 组织文化和激励问题（忽视长期稳定性、过度追求速度）

**分析原则**：
- 优先采用官方报告明确列出的根本原因
- 不仅分析技术层面，更要上升到管理和流程层面
- 区分直接原因和根本原因
- 识别系统性问题而非个人失误
- 所有分析都应基于官方报告提供的信息

### 步骤5：基于官方报告提供技术改进建议
**参考官方报告的"Action Items"和"Next Steps"章节**，智能体将生成具体的改进建议：

**技术层面**（基于官方报告的修复方案扩展）：
- 架构改进（去除单点、增加冗余、微服务解耦、输入验证）
- 代码层面（增加边界检查、异常处理、资源限制、最小权限原则）
- 配置管理（配置版本控制、灰度发布、回滚机制）
- 监控和告警（指标完善、告警分级、快速定位工具）
- 应急技术方案（熔断降级、流量限制、快速回滚、纵深防御）
- 安全检测加强（fuzzing、静态分析、渗透测试）

**管理层面**（基于官方报告的经验教训）：
- 开发流程优化（加强测试、Code Review、变更管理、SDLC）
- 培训和意识提升（故障案例分析、应急演练）
- 流程和文档建设（SOP更新、知识库完善）
- 资源投入（增加监控工具、自动化测试环境）
- 安全责任制和考核机制（明确权责、建立问责机制）
- 文化建设（重视稳定性、鼓励快速失败、无责复盘）

**输出要求**：
- 每条建议应具体可执行
- 按优先级排序（紧急/重要/长期）
- 说明预期效果和实施难度
- 尽量引用官方报告中的相关建议

### 步骤6：整合完整分析报告
将以上各步骤的分析结果整合成一份结构化的报告：

**报告结构**：
```
# [故障名称] 故障分析报告

## 1. 执行摘要
故障概述、影响范围、关键发现、核心结论

## 2. 故障基本信息
故障名称/编号、时间、影响范围、持续时间、严重等级

## 3. 信息来源说明
数据获取方式（CVE模式/通用模式）、官方报告来源、参考资料列表

## 4. 官方故障报告概要
基于官方报告的权威信息摘要

## 5. 时间线分析
按时间顺序排列的关键事件表格

## 6. 导火索与故障链分析
导火索说明、故障传播路径、放大因子

## 7. 根本原因分析
人员因素和组织架构因素

## 8. 改进建议
技术建议和管理建议（含优先级）

## 9. 参考资料
链接到官方报告、新闻报道、技术文档
```

## 资源索引
- CVE专用脚本：见 [scripts/fetch_cve_data.py](scripts/fetch_cve_data.py)
  用途：从NVD API获取CVE官方数据并爬取官方公告内容
  参数：cve_id - CVE编号字符串
  适用场景：CVE编号输入模式

- 通用脚本：见 [scripts/extract_webpage.py](scripts/extract_webpage.py)
  用途：从任意URL提取网页文本内容
  参数：url - 目标网页URL
  适用场景：互联网故障描述输入模式

## 注意事项
- **官方故障报告是最重要的参考资料**，所有技术分析应基于官方报告提供的信息
- 步骤1必须首先执行，根据输入类型选择相应脚本
- NVD API有速率限制（30请求/30秒），如遇限流错误请等待后重试
- 爬取网页时可能会遇到反爬机制，脚本会自动处理常见情况，但某些网站可能无法访问
- 如果无法找到官方报告，应基于多源新闻报道进行交叉验证，并在报告中说明数据来源和限制
- 分析过程中应保持客观中立，基于官方报告和事实，避免主观臆断
- 报告应面向技术决策者，语言应专业但不晦涩
- CVE模式和通用模式的输出报告格式保持一致，便于对比分析

## 使用示例

### 示例1：CVE漏洞分析（模式A）
```
功能：分析CVE-2021-44228 (Log4Shell)
输入：CVE-2021-44228
执行方式：
1. 智能体识别为CVE模式
2. 调用fetch_cve_data.py获取NVD数据并爬取官方公告
3. 智能体基于官方公告分析时间线、导火索、根因
4. 智能体生成技术改进建议
5. 智能体整合完整报告
关键点：JNDI注入、远程代码执行、CVSS 10.0
```

### 示例2：互联网故障分析（模式B）
```
功能：分析Facebook 2021年10月全球宕机
输入：Facebook 2021年10月4日宕机
执行方式：
1. 智能体识别为通用模式
2. 智能体搜索：Facebook outage post-mortem
3. 智能体定位官方博客的故障报告
4. 调用extract_webpage.py提取官方报告内容
5. 智能体基于官方报告分析（时间线、根因、建议）
6. 智能体整合完整报告
关键点：DNS配置错误、BGP路由问题、6小时宕机
```

### 示例3：云服务故障分析（模式B）
```
功能：分析阿里云某次故障
输入：阿里云2022年12月故障
执行方式：同示例2流程
关键分析点：
- 搜索阿里云官方技术博客的故障报告
- 提取官方时间线和根因分析
- 分析配置变更、系统设计等问题
- 生成针对性的改进建议
```

### 示例4：安全事件分析（模式B）
```
功能：分析某数据泄露事件
输入：某公司2023年数据泄露事件
执行方式：同示例2流程
关键分析点：
- 搜索官方声明和安全公告
- 提取事件时间线
- 分析漏洞类型和攻击路径
- 识别安全流程缺陷
- 生成安全改进建议
```

## 适用场景

### CVE模式适用场景
- 安全漏洞分析（CVE编号）
- 软件漏洞技术分析
- 漏洞利用和影响评估
- 安全补丁分析

### 通用模式适用场景
- 系统宕机（服务不可用、性能严重下降）
- 安全事件（数据泄露、未授权访问、账号劫持）
- 数据丢失（误删除、数据库故障、备份失败）
- 配置错误（DNS配置、路由配置、应用配置）
- 依赖故障（第三方服务故障、云服务中断）
- 流量激增（DOS攻击、突发流量、负载均衡失效）
- 部署故障（发布失败、回滚失败、版本回退）
- 网络故障（BGP路由问题、网络分区、带宽不足）
