# Style Guide -- Interior Design

## Style Identification (Ask First)

1. What existing pieces MUST stay? (often defines style)
2. What styles does user explicitly hate?
3. What is the building's architectural style?
4. Who uses this space and how?

## Core Styles

| Style | Key signals | Materials | Mixes with | Never with |
|-------|-------------|-----------|------------|------------|
| Scandinavian | Light woods, white, functional | Birch, wool, linen | Mid-century, Japandi | Baroque, Maximalist |
| Mid-Century | Organic curves, tapered legs | Teak, walnut, leather | Scandinavian, Contemporary | Traditional, Farmhouse |
| Contemporary | Clean lines, neutrals | Mixed metals, glass | Most styles | Very ornate |
| Mediterranean | Terracotta, arches, warmth | Clay, stone, ceramics | Rustic, Spanish | Scandinavian, Industrial |
| Industrial | Exposed brick, metal, raw | Steel, concrete | Mid-century, Contemporary | Traditional, Cottage |
| Traditional | Symmetry, dark wood, formal | Mahogany, velvet, silk | Transitional only | Industrial, Minimalist |

## Regional Context

| Building type | Lean toward | Avoid |
|---------------|-------------|-------|
| Andalusian cortijo | Mediterranean, Rustic | Nordic, Industrial |
| NYC loft | Industrial, Contemporary | Traditional |
| Parisian apartment | Traditional, French Contemporary | Industrial |
| Beach house | Coastal, Light | Dark Traditional |
| Mountain cabin | Rustic, Lodge | Urban Contemporary |

## Mixing Rules

**Safe:** Nordic + Mid-century (Japandi), Contemporary + one accent style.

**Danger:**
- More than 2 distinct styles = chaos
- Trends in permanent elements = regret in 5 years
- High-end styles on low budgets = looks cheap

## Budget-to-Style Fit

| Budget | Natural styles |
|--------|----------------|
| Low | Scandinavian (IKEA), Industrial (DIY), Bohemian (thrift) |
| Mid | Mid-century reproductions, Contemporary |
| High | Traditional, Designer, Bespoke |
