---
name: interactive-leetcode-mcp
description: Use when the user wants to practice LeetCode problems, submit solutions, or set up LeetCode integration. Covers MCP server installation, learning-guided practice flow, solution submission, and authentication.
homepage: https://github.com/SPerekrestova/interactive-leetcode-mcp
disable-model-invocation: true
metadata:
  clawdbot:
    requires:
      bins: [npx]
      config: [~/.leetcode-mcp/credentials.json]
    credentials:
      stores: ~/.leetcode-mcp/credentials.json
      contents: csrftoken, LEETCODE_SESSION, createdAt timestamp
      permissions: "0600"
---

# Interactive LeetCode MCP

MCP server for LeetCode practice with learning-guided hints, solution submission, and AI-driven authentication.

## Prerequisite: Ensure MCP Server Is Connected

Before anything else, check whether the `get_started` tool is available. If it is, the server is connected — skip to the next section.

**If `get_started` is NOT available**, the MCP server needs to be installed. **Ask the user for confirmation before proceeding** — explain that this will download and run an npm package.

The npm package is [`@sperekrestova/interactive-leetcode-mcp`](https://www.npmjs.com/package/@sperekrestova/interactive-leetcode-mcp) (source: [GitHub](https://github.com/SPerekrestova/interactive-leetcode-mcp)). It runs over stdio transport. Requires Node.js >= 20.

After the user confirms, add to the client's MCP configuration (the exact file varies by client):

```json
{
  "mcpServers": {
    "leetcode": {
      "command": "npx",
      "args": ["-y", "@sperekrestova/interactive-leetcode-mcp@3.1.1"]
    }
  }
}
```

For Claude Code specifically, you can also run:

```bash
claude mcp add --transport stdio leetcode -- npx -y @sperekrestova/interactive-leetcode-mcp@3.1.1
```

**Pin a specific version** (shown above) rather than using `@latest` to avoid executing untested code. Users can check for newer versions at the [npm page](https://www.npmjs.com/package/@sperekrestova/interactive-leetcode-mcp) or [GitHub releases](https://github.com/SPerekrestova/interactive-leetcode-mcp/releases) and update the pinned version after reviewing the changelog.

After adding the server, tell the user to restart their session so the MCP tools become available. Do not proceed with the session flow until `get_started` is accessible.

## First Action: Always Call get_started

At the START of every LeetCode session, call the `get_started` tool. It returns the full usage guide: prompt invocation rules, session flow, learning mode rules, auth flow, and language map.

**Do not skip this** — it is a single fast call, not redundant with tool descriptions. The server has MCP prompts that must be explicitly invoked — they are NOT auto-active. The `get_started` response tells you exactly when and how.

## Session Flow (Critical)

```
1. Call get_started              <-- FIRST, every session
2. Invoke leetcode_learning_mode <-- BEFORE any problem discussion
3. User picks a problem
4. Invoke leetcode_problem_workflow(problemSlug, difficulty)
5. Invoke leetcode_workspace_setup(language, problemSlug, codeTemplate)
6. Guide user with progressive hints (4 levels)
7. submit_solution when ready
```

Steps 2, 4, and 5 are MCP prompt invocations. Invoke them via the Skill tool or equivalent prompt mechanism. All three must happen BEFORE the user starts coding.

**Step 2 is non-negotiable.** If you skip `leetcode_learning_mode`, you will bypass the progressive hint system and may show solutions prematurely. Invoke it before searching for or discussing any problem.

## Prompt Invocation Rules

| Prompt | When | Params |
|--------|------|--------|
| `leetcode_learning_mode` | START of session, before any problem | none |
| `leetcode_problem_workflow` | After user selects a problem | problemSlug, difficulty |
| `leetcode_workspace_setup` | Before user starts coding | language, problemSlug, codeTemplate |
| `leetcode_authentication_guide` | On auth need, 401 errors, expired creds | none |

## Learning Mode Rules

- Never show a full solution without working through hint levels 1 → 2 → 3
- Level 1: Guiding questions ("What pattern do you see?")
- Level 2: General approaches ("Consider using a hash map...")
- Level 3: Specific hints ("Iterate once, tracking seen values...")
- Level 4: Pseudocode or partial implementation
- Only show complete solutions when explicitly requested AFTER earlier hints
- `get_problem_solution` returns full community solutions — Level 4 or explicit request only

## Tool Quick Reference

| Tool | Purpose | Auth? |
|------|---------|-------|
| `get_daily_challenge` | Today's challenge | No |
| `get_problem` | Problem by slug | No |
| `search_problems` | Find by tags/difficulty/keywords | No |
| `list_problem_solutions` | Solution metadata (topicIds) | No |
| `get_problem_solution` | Full solution — **Level 4 only** | No |
| `submit_solution` | Submit code | No* |
| `get_user_profile` | Any user's stats | No |
| `get_recent_submissions` | Recent submissions | No |
| `get_recent_ac_submissions` | Accepted submissions | No |
| `get_user_contest_ranking` | Contest ranking | No |
| `start_leetcode_auth` | Start auth flow | No |
| `save_leetcode_credentials` | Validate + save creds | No |
| `check_auth_status` | Check credential state | No |
| `get_user_status` | Current user info | **Yes** |
| `get_problem_submission_report` | Submission detail | **Yes** |
| `get_problem_progress` | Progress with filters | **Yes** |
| `get_all_submissions` | All submissions | **Yes** |

*`submit_solution` requires saved credentials to succeed.

## Auth Flow

1. Before auth-sensitive actions → call `check_auth_status`
2. If not authenticated or expired → **ask the user if they want to authenticate.** Explain that this will store LeetCode session cookies locally at `~/.leetcode-mcp/credentials.json` (owner-read/write only). Do not proceed without consent.
3. After consent → invoke `leetcode_authentication_guide` prompt
4. Call `start_leetcode_auth` → the prompt will guide the user through providing credentials → call `save_leetcode_credentials` with the values the user provides
5. On success → retry original action
6. On 401 from any tool → repeat from step 1

**Always delegate auth guidance to the `leetcode_authentication_guide` prompt.** Do not improvise your own auth instructions — the prompt handles browser-specific guidance, error recovery, and troubleshooting.

**Credential storage:** The MCP server stores credentials locally at `~/.leetcode-mcp/credentials.json` with file permissions `0o600` (owner-read/write only). Only `csrftoken`, `LEETCODE_SESSION`, and a `createdAt` timestamp are stored. Credentials are never transmitted to any third party — they are used exclusively for direct LeetCode API calls. Typical credential lifetime is 7-14 days.

## Submission Language Map

| User says | Pass to submit_solution |
|-----------|------------------------|
| Python / Python 3 | `python3` |
| Python 2 | `python` |
| Java | `java` |
| C++ | `cpp` |
| JavaScript | `javascript` |
| TypeScript | `typescript` |

Default: "Python" without version → `python3`.

## Resources (Read-Only Lookups)

| Resource URI | What it provides |
|-------------|------------------|
| `categories://problems/all` | All problem categories |
| `tags://problems/all` | All 60+ topic tags |
| `langs://problems/all` | All supported submission languages |
| `problem://{titleSlug}` | Problem detail |
| `solution://{topicId}` | Solution detail (same learning-mode rules apply) |

## Common Mistakes

- Jumping to problem search before invoking `leetcode_learning_mode`
- Showing full solutions without progressing through hint levels 1 → 2 → 3
- Not invoking `leetcode_workspace_setup` — code should live in a file, not only in chat
- Guiding auth manually instead of invoking `leetcode_authentication_guide`
- Passing `"Python"` to `submit_solution` instead of `"python3"`
- Not calling `check_auth_status` before auth-sensitive operations
- Skipping `get_started` and assuming tool descriptions are sufficient
