---
name: insula-memory
description: "Internal state awareness for AI agents. Energy, mood, and interoception. Part of the AI Brain series."
metadata:
  openclaw:
    emoji: "🌡️"
    version: "0.1.0"
    author: "ImpKind"
    requires:
      os: ["darwin", "linux"]
    tags: ["memory", "awareness", "ai-brain"]
---

# Insula Memory 🌡️

**Internal state awareness for AI agents.** Part of the AI Brain series.

## Status: 🚧 Under Development

This skill is being developed. Star/watch for updates!

## Concept

The insula processes interoception — awareness of internal bodily states. This skill will give AI agents:

- **State tracking** — energy, curiosity, engagement levels
- **Mood awareness** — not just performing emotions but having states
- **"Gut feelings"** — intuitive responses based on internal signals
- **Self-monitoring** — knowing when you're tired, overwhelmed, or energized

## AI Brain Series

| Part | Function | Status |
|------|----------|--------|
| [hippocampus](https://www.clawhub.ai/skills/hippocampus) | Memory formation, decay, reinforcement | ✅ Live |
| [amygdala-memory](https://www.clawhub.ai/skills/amygdala-memory) | Emotional processing | 🚧 Development |
| [basal-ganglia-memory](https://www.clawhub.ai/skills/basal-ganglia-memory) | Habit formation | 🚧 Development |
| [anterior-cingulate-memory](https://www.clawhub.ai/skills/anterior-cingulate-memory) | Conflict detection | 🚧 Development |
| **insula-memory** | Internal state awareness | 🚧 Development |

## Coming Soon

Based on neuroscience research on the insula's role in interoception and self-awareness.

---

*Built with ❤️ by the OpenClaw community*
