# 🔍 Instant Client Audit Report Generator — Close More Deals With AI-Powered Prospect Audits

**Slug:** `instant-client-audit-report`  
**Category:** Agency Tools / Sales Enablement  
**Powered by:** [Apify](https://www.apify.com?fpr=dx06p) + Claude AI

> Input any prospect's domain. Get a **full professional audit report** — website, SEO, ads, social media, reviews, tech stack & competitors — generated in minutes. Send it to close the deal before your first call.

---

## 💥 The #1 Trick Top Agencies Use to Close Clients

The best agencies don't wait for a call to pitch. They send a **free personalized audit** before the first meeting. The prospect sees the problems. They feel understood. They're already sold by the time you speak.

This skill automates that entire process. One domain in. One beautiful, detailed audit report out.

**What gets audited automatically:**
- 🌐 Website speed, UX issues & quick wins
- 🔍 SEO health — missing tags, broken links, keyword gaps
- 📣 Google Ads & Meta Ads activity (are they running ads? spending?)
- ⭐ Online reputation — Google reviews, Trustpilot, sentiment score
- 📱 Social media performance — posting frequency, engagement rate
- 🔧 Tech stack — what tools they're using (and what's missing)
- 🏆 Top 3 competitors comparison
- 💰 Estimated revenue leaks & growth opportunities

---

## 🛠️ Apify Actors Used

> 🚀 **Get started free on Apify — $5 credits included:**  
> 👉 [https://www.apify.com?fpr=dx06p](https://www.apify.com?fpr=dx06p)

| Actor | ID | Purpose |
|---|---|---|
| Website Content Crawler | `apify/website-content-crawler` | Full website crawl — pages, speed, UX, content |
| SEO Audit Tool | `tugkan/seo-audit` | Meta tags, headers, broken links, page speed |
| Google Search Scraper | `apify/google-search-scraper` | SERP rankings, competitor detection |
| Google Maps Reviews Scraper | `compass/crawler-google-places` | Star rating, review volume, sentiment |
| Tech Stack Detector | `apify/wappalyzer` | Full tech stack identification |
| Facebook Ads Scraper | `apify/facebook-ads-scraper` | Active ad campaigns, creatives, spend signals |
| Instagram Scraper | `apify/instagram-scraper` | Followers, engagement rate, posting frequency |

---

## ⚙️ Full Workflow

```
INPUT: Prospect domain + your agency service + competitor domains (optional)
        ↓
STEP 1 — Website Crawl & Speed Test
  └─ Load time, mobile score, broken links, missing CTAs, UX red flags
        ↓
STEP 2 — SEO Audit
  └─ Title tags, meta descriptions, H1s, keyword rankings, backlink signals
        ↓
STEP 3 — Ads Intelligence
  └─ Running Google/Meta ads? What creatives? How long? Estimated spend?
        ↓
STEP 4 — Reputation Scan
  └─ Google reviews rating, volume, last review date, sentiment analysis
        ↓
STEP 5 — Social Media Snapshot
  └─ Instagram/LinkedIn: followers, avg engagement, last post date
        ↓
STEP 6 — Tech Stack Analysis
  └─ What CRM, CMS, analytics, email tool, ad pixels are they using?
        ↓
STEP 7 — Competitor Benchmarking
  └─ How do they rank vs top 3 competitors on every metric?
        ↓
STEP 8 — Claude AI Generates Full Report
  └─ Executive summary with scores
  └─ Top 5 critical issues (ranked by revenue impact)
  └─ Top 5 quick wins (can be done in <30 days)
  └─ Personalized pitch for YOUR agency service
        ↓
OUTPUT: Beautiful structured report (JSON / Markdown / PDF-ready)
        ready to send to the prospect before your first call
```

---

## 📥 Inputs

```json
{
  "prospect_domain": "targetclient.com",
  "your_agency": {
    "name": "Your Agency",
    "core_service": "Google Ads Management",
    "speciality": "E-commerce brands doing $50K-$500K/month"
  },
  "competitor_domains": [
    "competitor1.com",
    "competitor2.com"
  ],
  "report_language": "en",
  "apify_token": "YOUR_APIFY_TOKEN"
}
```

---

## 📤 Output Example

```json
{
  "prospect": {
    "company": "FreshBrew Coffee",
    "domain": "freshbrewcoffee.com",
    "overall_score": 47,
    "score_label": "⚠️ Needs Work",
    "industry": "E-commerce / Food & Beverage"
  },
  "audit_scores": {
    "website_performance": { "score": 38, "label": "🔴 Poor", "note": "6.4s load time on mobile — losing 53% of visitors" },
    "seo_health": { "score": 52, "label": "🟡 Average", "note": "14 pages missing meta descriptions, not ranking for core keywords" },
    "paid_ads": { "score": 20, "label": "🔴 Critical", "note": "No active Google Ads campaigns detected — leaving money on the table" },
    "reputation": { "score": 74, "label": "🟢 Good", "note": "4.3★ on Google (87 reviews) but last response was 4 months ago" },
    "social_media": { "score": 31, "label": "🔴 Poor", "note": "Last Instagram post: 47 days ago. Avg engagement: 0.8%" },
    "tech_stack": { "score": 60, "label": "🟡 Average", "note": "Shopify + Klaviyo detected. No heatmap tool. No retargeting pixel active." }
  },
  "top_5_critical_issues": [
    {
      "rank": 1,
      "issue": "No Google Ads = Zero Intent Traffic",
      "revenue_impact": "Estimated $8,000-$15,000/month in missed sales",
      "fix": "Launch branded + category search campaigns immediately"
    },
    {
      "rank": 2,
      "issue": "6.4s Mobile Load Time",
      "revenue_impact": "53% of mobile visitors bounce before page loads",
      "fix": "Compress images, remove unused Shopify apps, enable CDN"
    },
    {
      "rank": 3,
      "issue": "No Retargeting Pixel Active",
      "revenue_impact": "100% of website visitors lost forever with no retargeting",
      "fix": "Install Meta Pixel + Google Tag Manager in 30 minutes"
    },
    {
      "rank": 4,
      "issue": "47-Day Social Media Gap",
      "revenue_impact": "Algorithm deprioritizing account, losing organic reach daily",
      "fix": "Resume 3x/week posting with content batching system"
    },
    {
      "rank": 5,
      "issue": "0 Unanswered Google Reviews in 4 Months",
      "revenue_impact": "Signals neglect to potential customers checking reviews",
      "fix": "Set up review response templates + weekly 10-min response routine"
    }
  ],
  "top_5_quick_wins": [
    "Install Meta Pixel today (30 min, free)",
    "Compress homepage images — can reduce load time by 40% instantly",
    "Add meta descriptions to 14 missing pages (2 hours, big SEO impact)",
    "Respond to all Google reviews this week (builds trust signal)",
    "Reactivate Instagram with 1 post using existing product photos"
  ],
  "competitor_benchmark": {
    "vs_competitor_1": "They are running 12 active Google Ad campaigns vs your 0",
    "vs_competitor_2": "They post on Instagram daily vs your 47-day gap",
    "summary": "You are being outspent and out-distributed on every channel"
  },
  "agency_pitch": {
    "hook": "FreshBrew is sitting on a goldmine — the product is great, the reviews prove it. But you're invisible on paid search and losing $8K-$15K/month in intent traffic to competitors who ARE running Google Ads.",
    "proposed_service": "Google Ads Management — we'll get you live in 7 days and profitable within 30.",
    "social_proof": "We scaled a similar Shopify coffee brand from $22K to $89K/month in 4 months using the exact same approach."
  }
}
```

---

## 🧠 Claude AI Report Generation Prompt

```
You are a senior digital marketing consultant writing a prospect audit report.

SCRAPED DATA:
- Website metrics: {{website_data}}
- SEO scan results: {{seo_data}}
- Ad activity: {{ads_data}}
- Reviews & reputation: {{reviews_data}}
- Social media stats: {{social_data}}
- Tech stack detected: {{tech_stack}}
- Competitor data: {{competitor_data}}

MY AGENCY:
- Core service: {{agency_service}}
- Niche speciality: {{agency_niche}}
- Best case study: {{case_study}}

GENERATE:
1. An overall score (0-100) with label (Excellent / Good / Needs Work / Critical)
2. Individual scores per category with a 1-line diagnostic note
3. Top 5 critical issues ranked by estimated revenue impact (include $ estimates)
4. Top 5 quick wins achievable in under 30 days
5. A competitor benchmark summary (2-3 sentences)
6. A personalized agency pitch:
   - A compelling hook referencing their biggest pain point
   - Your proposed service as the solution
   - Your most relevant case study with specific numbers

TONE: Expert but approachable. Direct. No fluff. Make them feel seen.
OUTPUT: Valid JSON only. No markdown. No preamble.
```

---

## 💰 Cost Estimate

| Reports | Apify CU | Cost | Prospects Audited |
|---|---|---|---|
| 5 | ~40 CU | ~$0.40 | 5 full audits |
| 20 | ~160 CU | ~$1.60 | 20 full audits |
| 50 | ~380 CU | ~$3.80 | 50 full audits |
| 200 | ~1,400 CU | ~$14 | 200 full audits |

> 💡 **$5 free Apify credits on signup** = your first ~60 prospect audits completely free.  
> 👉 [Create your free Apify account → https://www.apify.com?fpr=dx06p](https://www.apify.com?fpr=dx06p)

---

## 🔗 How to Use the Report

| Use Case | How |
|---|---|
| **Pre-call closer** | Send the PDF audit 24h before your discovery call |
| **Cold email attachment** | "I ran a free audit on your site — here's what I found" |
| **LinkedIn outreach** | DM with the top 3 issues as a hook to start conversation |
| **Paid audit service** | Charge $200-$500 per report to SMBs (10x ROI on Apify cost) |
| **Onboarding baseline** | Use as the Day 1 benchmark for new clients |
| **Monthly reporting** | Re-run monthly to show progress to existing clients |

---

## 📊 Why This Is The Most Valuable Skill in Your Catalog

| Feature | Any Other Skill | **Instant Audit Report** |
|---|---|---|
| Finds leads | ✅ | ✅ |
| Generates outreach | ✅ | ✅ |
| Audits the full business | ❌ | ✅ |
| Estimates revenue leaks in $ | ❌ | ✅ |
| Benchmarks vs competitors | ❌ | ✅ |
| Pre-built agency pitch | ❌ | ✅ |
| Can be sold as a paid service | ❌ | ✅ |
| Works for ANY agency niche | ❌ | ✅ |

---

## 🚀 Setup in 3 Steps

**Step 1 — Get your Apify API Token**  
Sign up free → [https://www.apify.com?fpr=dx06p](https://www.apify.com?fpr=dx06p)  
Go to: **Settings → Integrations → API Token**

**Step 2 — Configure your agency profile**  
Add your core service, niche, and best case study with real numbers.

**Step 3 — Input your prospect domain & run**  
Full audit generated in 3–5 minutes. Ready to send.

---

## ⚡ Pro Tips to Close More Deals With This Skill

- **Subject line that converts:** *"I ran a free audit on [Company] — found 3 issues costing you $X/month"*
- **Send the report as a Loom walkthrough** — 5-min video explainer converts 3x better than a PDF alone
- **Focus your pitch on Issue #1 only** — don't overwhelm. One problem = one solution = one offer
- **Re-run the audit after 90 days** as a progress report to retain clients
- **Sell the audit itself** — SMBs will pay $200-$500 for this level of insight

---

## 🏷️ Tags

`audit` `lead-generation` `agencies` `freelancers` `seo` `google-ads` `sales-enablement` `apify` `prospect-research` `competitive-analysis` `client-acquisition` `reporting`

---

*Powered by [Apify](https://www.apify.com?fpr=dx06p) — The Web Scraping & Automation Platform*
