---
name: instagram-master
version: 1.0.0
description: Complete Instagram content system for any business — feed posts, Reels scripts, Carousels, Stories, hashtag sets, posting schedule, auto-engagement templates, and a 6-month growth strategy. Works for any niche.
tags: [instagram, social-media, content-creation, reels, hashtags, engagement, marketing, growth]
author: contentai-suite
license: MIT
---

# Instagram Master — Universal Instagram Content System

## What This Skill Does

Creates a complete, professional Instagram content strategy and generates ready-to-post content for any business or personal brand. From single posts to full weekly content batches — in your brand's voice.

## How to Use This Skill

**Input format:**
```
BUSINESS NAME: [Your brand]
NICHE: [Your industry]
TARGET AUDIENCE: [Who follows you — age, interests, pain points]
ACCOUNT HANDLE: [@yourhandle]
TONE: [Your brand voice — e.g., professional, fun, bold, empathetic]
CONTENT PILLARS: [3-5 main topics you post about]
GOAL: [Followers / Leads / Sales / Brand awareness]
LOCATION: [City/Country or "Global"]
```

---

## Content Mix Strategy (70/20/10 Rule)

| Type | % | Purpose |
|------|---|---------|
| Value & Education | 70% | Build trust, saves, shares |
| Personal & Behind the Scenes | 20% | Connection, authenticity |
| Sales & Promotion | 10% | Direct lead/sale generation |

---

## Post Formats & Templates

### 1. Feed Post — Motivational/Insight
```
[HOOK — 1 powerful sentence that stops the scroll]

[Identify the problem — 2-3 sentences your audience recognizes]

[Your perspective/solution — 3-4 sentences]

[Personal note — 1-2 sentences showing vulnerability or story]

[CTA — clear, specific next step]

[Hashtags — 5-15 relevant tags]
```

**Example prompt:**
```
Write an Instagram feed post for [BUSINESS NAME] about [TOPIC].
Hook: start with a bold or counterintuitive statement.
Body: identify a common mistake or struggle in [NICHE].
Lesson: share the insight or solution.
CTA: invite them to comment or visit link in bio.
Tone: [TONE]. Max 300 words.
```

### 2. Feed Post — Educational (List Format)
```
[NUMBER hook: "3 reasons why..." / "The truth about..."]

1️⃣ [Point 1 — short and punchy]
2️⃣ [Point 2 — surprising or practical]
3️⃣ [Point 3 — immediately actionable]

[Conclusion — 1-2 sentences]

[CTA — question to spark comments]
```

### 3. Reels Script (30-90 seconds)
```
HOOK (0-3 sec): [Bold statement or question — shown on screen]
BODY (3-50 sec): [3 points delivered quickly, dynamic filming]
PAYOFF (50-75 sec): [The solution or key takeaway]
CTA (75-90 sec): [Follow for more / Comment below / Link in bio]
```

**Reel prompt:**
```
Write a Reels script for [BUSINESS NAME] on the topic: [TOPIC].
Duration: 45 seconds. 3 key points. Hook must stop the scroll in 3 seconds.
Include: on-screen text suggestions and delivery tone notes.
End with a CTA to [desired action].
```

### 4. Carousel Post (5-8 slides)
```
Slide 1: HOOK + title (bold visual text)
Slide 2-6: 1 point per slide (short text, visual-first)
Slide 7: Summary — "Save this for later"
Slide 8: CTA + @yourhandle
```

**Carousel prompt:**
```
Create a carousel post outline for [BUSINESS NAME] on [TOPIC].
7 slides. Each slide: headline (max 8 words) + supporting text (max 30 words).
Slide 1 hook must be click-worthy. Final slide CTA: [desired action].
```

### 5. Story Sequence (3-5 slides)
```
Story 1: Question or poll ("Do you struggle with...?")
Story 2: Personal moment / behind the scenes
Story 3: Tip or insight
Story 4: Swipe up / DM / Link click
```

---

## Hashtag Strategy

### How to Build Your Hashtag Sets

**Mix these 4 tiers per post:**
- 3-4 × Large (1M+ posts) — reach
- 4-5 × Medium (100K-1M posts) — discoverability
- 3-4 × Small/Niche (<100K posts) — engagement
- 1-2 × Brand-specific — community

**Generate sets with this prompt:**
```
Create 3 Instagram hashtag sets for [BUSINESS NAME] in [NICHE]:
Set A: [core service/product posts]
Set B: [educational/value posts]
Set C: [personal/behind-scenes posts]
Each set: 15 hashtags mixing large (3-4), medium (5-6), niche (4-5), branded (1-2).
Location: [LOCATION if local business].
```

---

## Posting Schedule Template

| Day | Content Type | Best Time |
|-----|-------------|-----------|
| Monday | Motivational/mindset feed post | 7:00 AM |
| Tuesday | Educational carousel | 12:00 PM |
| Wednesday | Reels | 6:00 PM |
| Thursday | Behind the scenes (Story + feed) | 8:00 AM |
| Friday | Weekend tip or insight | 7:30 AM |
| Saturday | Personal / community post | 10:00 AM |
| Sunday | Week prep / inspirational | 11:00 AM |

**Minimum:** 4x/week posting
**Optimal:** 6x/week + daily Stories

---

## Auto-Engagement Templates

### Comment Reply Templates

**On motivational posts:**
```
Thank you! Does this resonate with your experience? Share below! 💪
```

**On questions about your service:**
```
Great question! Send me a DM and I'll give you a personal answer 🙌
```

**On "how do I get started?" comments:**
```
That's exactly why I [your offer]! Check the link in bio 👊
```

**On compliments:**
```
This means so much, thank you! 🙏 Stay tuned for more on this topic!
```

### DM Welcome Message (new followers)
```
Hey [First Name]! 👋 Thanks for following [BRAND NAME].
I share [VALUE PROP — what they'll learn/get from following you].
Quick question — what's your biggest challenge with [NICHE TOPIC]?
I reply to every message personally 💪
```

---

## 6-Month Growth Strategy

### Month 1-2: Foundation
- Post consistently 4-5x/week
- Define and test 3 content pillars
- Stories daily (casual, real, interactive)
- 10 minutes/day manual engagement on relevant hashtags

### Month 3-4: Acceleration
- Prioritize Reels (highest reach algorithm boost)
- Collaborations with complementary accounts in your niche
- User-generated content — ask customers to tag you
- Go Live monthly for Q&A

### Month 5-6: Authority
- Instagram as lead generation machine
- DM automation for new leads
- Test paid promotion on 1-2 best-performing posts
- Analytics review: double down on what works, cut what doesn't

---

## Monthly Content Batch Workflow

```
WEEKLY BATCH SESSION (2 hours, Monday):
1. Generate week's content via AI (30 min)
2. Review and personalize (15 min)
3. Create or source visuals (30 min)
4. Schedule via Buffer/Later/Meta Business Suite (30 min)
5. Prep Stories for each day (15 min)
```

---

## Use with ContentAI Suite

This skill works seamlessly with **[ContentAI Suite](https://contentai-suite.vercel.app)** — a free multi-agent marketing platform that generates your entire week of Instagram content in one session.

→ **Try it free:** https://contentai-suite.vercel.app
