# Instagram Content Package Output Template

## Content Structure

Copy this template for each Instagram content package you generate:

---

## Instagram Content Package

### 📦 Product Overview

**Product Name**: [Insert product name]
**Price**: [Insert price]
**Platform**: [Amazon/Shopify/etc]
**Target Audience**: [Demographic]

---

### 🎨 Content Format: [Feed Post / Carousel / Story / Reel]

**Rationale**: [Why this format works for this product]

---

### 📸 Image/Video Brief

#### Visual Style
- **Aesthetic**: [Minimalist / Bold / Luxury / Playful / Warm / Cool / etc]
- **Color Palette**: [3-5 colors that match product/brand]
- **Mood**: [Calm / Energetic / Sophisticated / Friendly / etc]

#### Composition Guidelines
- **Primary Shot**: [Product angle - flat lay, lifestyle, detail, etc]
- **Background**: [Clean / Lifestyle setting / Gradient / Texture]
- **Props**: [Items that enhance context without distracting]
- **Lighting**: [Natural / Studio / Side-lit / Backlit]
- **Text Overlay** (optional): [Key benefit or price if relevant]

#### Image Specifications
- **Dimensions**: [1080x1080 for feed / 1080x1350 for portrait / 1080x1920 for story]
- **Format**: [JPG for photos / PNG for graphics / MP4 for video]
- **File Size**: [Under 2MB for optimal upload]

---

### ✍️ Caption

#### Hook (First Line)
```
[Scroll-stopping opening line - question, bold statement, or emotional trigger]
```

#### Body
```
[2-3 sentence value proposition]
- [Key benefit 1]
- [Key benefit 2]
- [Key benefit 3 if applicable]
```

#### CTA (Call to Action)
```
[Clear action - link in bio, DM, save, share, tag]
```

#### Full Caption
```
[Hook]

[Body text with line breaks for readability]

[CTA]

[Hashtags - see section below]
```

**Caption Character Count**: [150 / 300 / etc]
**First Line Preview**: [Test how hook appears in feed]

---

### #️⃣ Hashtag Strategy (30 total)

#### Branded/Niche Tags (3-5)
```
#[yourbrand]
#[specificproduct]
#[nicheterm1]
#[nicheterm2]
#[nicheterm3]
```

#### Trend/Category Tags (10-15)
```
#[category1]
#[category2]
#[trendingtag1]
#[trendingtag2]
...
```

#### Broad Tags (5-10)
```
#fashion
#instagood
#photooftheday
#style
#love
```

**Full Hashtag Set**:
```
[All 30 hashtags in one block for easy copy-paste]
```

---

### ⏰ Posting Strategy

#### Best Times to Post
- **Weekdays**: [Time - e.g., 9-10am or 7-8pm]
- **Weekends**: [Time - e.g., 10-11am or 6-7pm]
- **Timezone**: [Specify timezone]

#### Frequency
- **Feed Posts**: [X times per week]
- **Stories**: [X times per day/week]
- **Reels**: [X times per week]

#### Cross-Post Suggestions
- [Facebook: Yes/No + timing]
- [TikTok: Yes/No + format adjustments]
- [Pinterest: Yes/No + board selection]

---

### 💬 Engagement Preparation

#### Comment Responses to Prepare
1. **For "How much?" questions**: [Price + CTA]
2. **For "Where to buy?" questions**: [Link in bio direction]
3. **For "Is it worth it?" questions**: [Value proposition]

#### Story Interactions
- **Poll Questions**: [Option A vs Option B]
- **Question Sticker**: [Open-ended question]
- **Quiz**: [Trivia about product/benefits]
- **Countdown Sticker**: [For limited-time offers]

---

### 📊 Success Metrics

Track these after posting:
- **Reach**: [Expected range]
- **Engagement Rate**: [Target - e.g., 2-5%]
- **Saves**: [Target - indicates valuable content]
- **Shares**: [Target - indicates shareability]
- **Profile Visits**: [Target - indicates interest]
- **Link Clicks**: [For shoppable posts]

---

### 🔄 Content Repurposing Ideas

Extend this content across formats:
1. **Feed Post** → **Story**: [Turn into 3-4 story frames]
2. **Carousel** → **Reel**: [Animate slides into video]
3. **Caption Highlights** → **Text Post**: [Quote the hook]
4. **Product Details** → **Guide**: [Educational carousel]

---

### 📝 Notes for Creator

- [Special instructions for photographer/designer]
- [Brand voice guidelines]
- [Things to avoid]
- [Compliance notes (if applicable)]

---

## Checklist Before Publishing

- [ ] Image/video meets quality standards
- [ ] Caption hook is strong
- [ ] CTA is clear
- [ ] Hashtags are relevant and researched
- [ ] Link in bio is updated (if applicable)
- [ ] Post scheduled for optimal time
- [ ] Story highlights organized (if applicable)
- [ ] Engaged with comments within 1 hour after posting

---

**Generated by Instagram Marketing Skill**
**Date**: [Generation date]
