# Instagram Hashtag Strategy

## The 3-Tier Formula

### Tier 1: Niche/Branded Tags (3-5)
**Purpose**: High relevance, targeted audience
**Volume**: 10k-100k posts
**Examples**: #yourbrandname #specificproduct #nicheterm

### Tier 2: Trend/Category Tags (10-15)
**Purpose**: Moderate reach, active communities
**Volume**: 100k-1M posts
**Examples**: #fashionhacks #techdeals #homede cor

### Tier 3: Broad Tags (5-10)
**Purpose**: Maximum reach, discoverability
**Volume**: 1M+ posts
**Examples**: #fashion #tech #decor #instagood

## Research Framework

### Step 1: Competitor Analysis
```
1. Identify 5-10 successful accounts in your niche
2. Note their top-performing hashtags
3. Look for patterns in tag combinations
```

### Step 2: Hashtag Testing
```
Week 1: Test Set A (30 tags)
Week 2: Test Set B (30 tags)
Week 3: Mix top performers from A + B
```

### Step 3: Performance Tracking
Monitor these metrics:
- Reach from hashtags
- Follower growth rate
- Engagement rate
- Save counts

## Category-Specific Tag Libraries

### Fashion & Beauty
**Niche**: #ootdstyle #fashioninspo #beautyhacks #makeuptutorial #skincareroutine
**Trend**: #fashiondiaries #beautytips #styleinspiration #makeuplooks #glowingskin
**Broad**: #fashion #beauty #style #makeup #skincare #instafashion #beautyblogger

### Tech & Gadgets
**Niche**: #techdeals #gadgetlover #techreview #unboxing #setup
**Trend**: #techtrends #gadgets #techlife #newtech #technews
**Broad**: #technology #gadgets #tech #innovation #smartphone #laptop #camera

### Food & Beverage
**Niche**: #foodphotography #recipeideas #healthyfood #instafood #foodlover
**Trend**: #foodstagram #foodblogger #homecooking #yummy #delicious
**Broad**: #food #foodie #instagood #yummy #delicious #homemade #cooking

### Home & Decor
**Niche**: #homedecor #interiordesign #roommakeover #homedesign #decor
**Trend**: #homedesign #interiors #apartmenttherapy #homestyling #hacks
**Broad**: #home #decor #design #interior #architecture #house #livingroom

### Lifestyle & Travel
**Niche**: #travelgram #lifestyleblogger #dailyvlog #lifehacks #wanderlust
**Trend**: #travelphotography #lifestyle #instatravel #vacationmode #adventure
**Broad**: #travel #lifestyle #photooftheday #instagood #explore #wanderlust

## Avoid These Hashtag Mistakes

### ❌ DON'T:
- Use banned hashtags (check regulary)
- Overuse generic tags like #follow #like4like
- Mix irrelevant hashtags for reach
- Use the exact same 30 tags every post
- Include hashtags in the middle of captions

### ✅ DO:
- Rotate hashtag sets regularly
- Mix hashtag sizes (small + medium + large)
- Research trending hashtags weekly
- Create branded hashtags for your business
- Monitor hashtag performance

## Branded Hashtag Creation

### Rules for Good Branded Hashtags
1. **Keep it short** (under 15 characters)
2. **Make it memorable** (easy to spell/remember)
3. **Keep it relevant** (connects to brand/product)
4. **Check availability** (not overused)

### Examples
- Nike: #justdoit #nikerun
- Lululemon: #thesweatlife
- GoPro: #goprohero
- Airbnb: #airbnbexperience

## Seasonal & Trending Hashtags

### Monthly Calendar
- January: #newyearnewme #winter #january
- February: #valentines #love #february
- March: #springishere #internationalwomensday
- April: #spring #april #earthday
- May: #mothersday #may #memorialday
- June: #summer #fathersday #pridemonth
- July: #july4th #summer #independenceday
- August: #backtoschool #summervibes
- September: #fallfashion #laborday #autumn
- October: #halloween #october #spookyseason
- November: #thanksgiving #grateful #november
- December: #christmas #holidays #december

### Trend Monitoring
Check these sources weekly:
- Instagram Explore page hashtags
- Influencer posts in your niche
- Twitter trending topics (for crossover)
- Google Trends for related searches
