---
name: insta-cog
description: "Full video production from a single prompt. Script, shoot, stitch, score — automatically. 30s to 4-minute Instagram Reels, TikToks, Stories, and carousels with consistent characters and agentic editing. The most advanced AI video suite for social media content, powered by #1 on DeepResearch Bench (Feb 2026)."
metadata:
  openclaw:
    emoji: "📸"
author: CellCog
dependencies: [cellcog]
---

# Insta Cog - Full Video Production From a Single Prompt

**Script, shoot, stitch, score — automatically.** The most advanced AI video suite, powered by #1 on DeepResearch Bench (Feb 2026).

No other AI platform generates multi-scene, production-ready Reels and TikToks from a single prompt. CellCog handles the entire pipeline: coherent script, scene-by-scene generation with consistent characters, background music, and automatic editing — 30 seconds to 4 minutes, ready to post. Plus carousels, Stories, and static posts.

---

## Prerequisites

This skill requires the `cellcog` skill for SDK setup and API calls.

```bash
clawhub install cellcog
```

**Read the cellcog skill first** for SDK setup. This skill shows you what's possible.

**Quick pattern (v1.0+):**
```python
# Fire-and-forget - returns immediately
result = client.create_chat(
    prompt="[your social content request]",
    notify_session_key="agent:main:main",
    task_label="insta-content",
    chat_mode="agent"  # Agent mode for most content
)
# Daemon notifies you when complete - do NOT poll
```

---

## What Content You Can Create

### Reels & TikToks

Short-form video that stops the scroll:

- **Trending Format Videos**: "Create a 15-second Reel using the 'day in my life' format for a coffee shop"
- **Product Showcases**: "Make a TikTok showing our new sneakers with trending transitions"
- **Educational Clips**: "Create a 30-second explainer about compound interest for Gen Z"
- **Behind-the-Scenes**: "Make a BTS Reel of a bakery kitchen with satisfying visuals"
- **Transformation Videos**: "Create a before/after transformation Reel for a home renovation"

**Example prompt:**
> "Create a 20-second Instagram Reel for a matcha cafe:
> 
> Hook: 'POV: You found the best matcha in the city'
> Show: Barista making ceremonial matcha, latte art, aesthetic interior shots
> Vibe: Cozy, ASMR-style sounds, warm lighting
> 
> End with: Shop name and 'link in bio'
> 
> Trending audio style - chill lo-fi beats."

### Instagram Carousels

Multi-slide content that educates and engages:

- **Educational Carousels**: "Create a 10-slide carousel explaining how to start investing"
- **Listicles**: "Make a '7 productivity hacks' carousel with bold graphics"
- **Storytelling**: "Create a carousel telling our brand's origin story"
- **Tips & Tricks**: "Make a carousel with 5 Photoshop shortcuts every designer needs"
- **Infographics**: "Create a data visualization carousel about climate change"

**Example prompt:**
> "Create a 7-slide Instagram carousel: '7 Morning Habits of Successful People'
> 
> Slide 1: Hook - 'Steal these morning habits'
> Slides 2-6: One habit each with icon and brief explanation
> Slide 7: CTA - 'Save this & follow for more'
> 
> Style: Clean, modern, muted earth tones
> Font: Bold sans-serif for headlines"

### Instagram Posts

Single-image content that pops:

- **Quote Posts**: "Create an inspirational quote graphic with modern design"
- **Announcement Posts**: "Make a product launch announcement post"
- **Meme-Style Posts**: "Create a relatable meme for the marketing industry"
- **Aesthetic Shots**: "Generate a lifestyle image for a wellness brand"
- **Infographic Posts**: "Create a single-image infographic about sleep statistics"

### Stories

Ephemeral content that connects:

- **Poll Stories**: "Create a Story template with engagement polls"
- **Q&A Stories**: "Design a 'Ask me anything' Story template"
- **Countdown Stories**: "Make a product launch countdown Story sequence"
- **Behind-the-Scenes**: "Create BTS Story content for a photoshoot"

---

## Platform-Specific Formats

### Instagram Specs

| Format | Dimensions | Duration |
|--------|------------|----------|
| Feed Post | 1080×1080 (square) or 1080×1350 (portrait) | - |
| Carousel | 1080×1080 or 1080×1350 | Up to 10 slides |
| Reels | 1080×1920 (9:16) | 15-90 seconds |
| Stories | 1080×1920 (9:16) | 15 seconds each |

### TikTok Specs

| Format | Dimensions | Duration |
|--------|------------|----------|
| Video | 1080×1920 (9:16) | 15 sec - 10 min |
| Photo Mode | 1080×1920 | Up to 35 images |

---

## Content Styles

CellCog can create content in various aesthetics:

| Style | Best For | Characteristics |
|-------|----------|-----------------|
| **Clean Minimal** | Professional brands, wellness | White space, muted colors, simple typography |
| **Bold & Bright** | Youth brands, entertainment | Saturated colors, dynamic layouts, playful |
| **Dark Aesthetic** | Tech, gaming, luxury | Dark backgrounds, neon accents, edgy |
| **Organic/Natural** | Food, lifestyle, eco brands | Earth tones, textures, warm lighting |
| **Y2K/Retro** | Fashion, music, Gen Z | Nostalgic elements, gradients, playful chaos |
| **Corporate Modern** | B2B, fintech, SaaS | Professional, structured, trustworthy |

---

## Chat Mode for Social Content

| Scenario | Recommended Mode |
|----------|------------------|
| Single posts, Stories, standard Reels | `"agent"` |
| Multi-part campaigns, brand storytelling series, complex video concepts | `"agent team"` |

**Use `"agent"` for most social content.** Individual posts, Reels, and carousels execute well in agent mode.

**Use `"agent team"` for campaign-level thinking** - when you need a cohesive content strategy across multiple pieces or complex creative direction.

---

## Example Prompts

**TikTok product video:**
> "Create a 15-second TikTok for wireless earbuds:
> 
> Hook (first 2 sec): 'Wait, these are only $30?!'
> Demo: Show features - noise cancellation, case, wearing them
> Social proof: 'Over 10,000 5-star reviews'
> CTA: 'Link in bio'
> 
> Fast cuts, trending transition style, upbeat music vibe."

**Educational carousel:**
> "Create an Instagram carousel: 'How to negotiate your salary'
> 
> Target: Young professionals, first job negotiation
> 
> Slides:
> 1. Hook: 'I got a $15K raise using these 5 steps'
> 2. Research market rates
> 3. Document your wins
> 4. Practice the conversation
> 5. Ask for more than you want
> 6. Get it in writing
> 7. CTA: Save & share
> 
> Bold, confident design. Blue and white."

**Aesthetic brand post:**
> "Create an Instagram post for a luxury candle brand:
> 
> Show: A lit candle in a minimalist setting, warm golden hour lighting
> Vibe: Cozy, aspirational, 'that girl' aesthetic
> Text overlay: None (let the image speak)
> 
> Should feel like it belongs on a curated feed."

---

## Tips for Better Social Content

1. **Lead with the hook**: First 1-2 seconds determine if people keep watching. Make it count.

2. **Know the platform**: TikTok is raw and trendy. Instagram is polished and aesthetic. Same message, different execution.

3. **Specify the vibe**: "Cozy autumn aesthetic" or "high-energy hype" gives CellCog clear creative direction.

4. **Include CTAs**: "Save this", "Follow for more", "Link in bio" - tell people what to do next.

5. **Reference trends**: Mention specific formats ("Get ready with me", "POV", "storytime") for platform-native content.

6. **Think mobile-first**: All content will be viewed on phones. Bold text, clear visuals, vertical format.
