# Full Source Directory — Inspiration

Complete reference of inspiration sources organized by category.

## UI/UX — Mobile

### Screenshot Libraries
| Source | Focus | Cost | URL |
|--------|-------|------|-----|
| **Mobbin** | iOS/Android patterns | Free/Paid | https://mobbin.com |
| **Screenlane** | Mobile UI by category | Free | https://screenlane.com |
| **UI Sources** | App design systems | Paid | https://www.uisources.com |
| **Scrnshts** | App screenshots | Free | https://scrnshts.club |
| **AppShopper** | iOS screenshots | Free | https://appshopper.com |
| **Nice, Very Nice** | Curated iOS apps | Free | https://www.niceverynice.com |

### User Flows
| Source | Focus | Cost | URL |
|--------|-------|------|-----|
| **Page Flows** | Screen recordings | Paid | https://pageflows.com |
| **UX Archive** | User flows | Free | https://uxarchive.com |
| **Really Good UX** | UX emails + flows | Free | https://www.reallygoodux.io |
| **User Onboard** | Onboarding teardowns | Free | https://useronboard.com |

### UI Components
| Source | Focus | Cost | URL |
|--------|-------|------|-----|
| **Collect UI** | UI by component type | Free | https://collectui.com |
| **UI Garage** | Specific patterns | Free | https://uigarage.net |
| **Call to Idea** | CTAs and buttons | Free | https://www.calltoidea.com |
| **Empty States** | Empty state designs | Free | https://emptystat.es |
| **Pttrns** | Mobile patterns | Free | https://www.pttrns.com |

## UI/UX — Web

### Modern Web Design
| Source | Focus | Cost | URL |
|--------|-------|------|-----|
| **Godly** | Contemporary design | Free | https://godly.website |
| **Awwwards** | Award-winning sites | Free | https://awwwards.com |
| **CSS Design Awards** | CSS innovation | Free | https://cssdesignawards.com |
| **The FWA** | Cutting-edge digital | Free | https://thefwa.com |
| **Site Inspire** | Clean web design | Free | https://siteinspire.com |
| **Httpster** | Trendy websites | Free | https://httpster.net |
| **Minimal Gallery** | Minimal design | Free | https://minimal.gallery |
| **siteInspire** | Curated web design | Free | https://www.siteinspire.com |

### Landing Pages
| Source | Focus | Cost | URL |
|--------|-------|------|-----|
| **Landingfolio** | Landing pages | Free/Paid | https://landingfolio.com |
| **Lapa Ninja** | Landing gallery | Free | https://lapa.ninja |
| **SaaS Pages** | SaaS landings | Free | https://saaspages.xyz |
| **SaaS Landing Page** | SaaS examples | Free | https://saaslandingpage.com |
| **One Page Love** | Single page sites | Free | https://onepagelove.com |
| **Land-book** | Landing inspo | Free | https://land-book.com |
| **Page Collective** | Curated pages | Free | https://pagecollective.com |

### Specific Niches
| Source | Focus | Cost | URL |
|--------|-------|------|-----|
| **SaaS Interface** | SaaS dashboards | Free | https://saasinterface.com |
| **Dark Mode Design** | Dark UI patterns | Free | https://www.darkmodedesign.com |
| **Navbar Gallery** | Navigation patterns | Free | https://www.navbar.gallery |
| **Footer Design** | Footer examples | Free | https://www.footer.design |
| **Best Website Gallery** | Curated sites | Free | https://bestwebsite.gallery |
| **Commerce Cream** | E-commerce | Free | https://commercecream.com |
| **Ecomm Design** | E-commerce design | Free | https://ecomm.design |

## AI-Generated Art

### Multi-Model Galleries
| Source | Focus | URL |
|--------|-------|-----|
| **PromptHero** | Prompts + images, all models | https://prompthero.com |
| **OpenArt** | Multi-model discovery | https://openart.ai |
| **Lexica** | Stable Diffusion search | https://lexica.art |
| **PlaygroundAI** | AI art community | https://playgroundai.com |
| **Krea** | AI design platform | https://krea.ai |
| **Arthub.ai** | AI art showcase | https://arthub.ai |

### Midjourney Specific
| Source | Focus | URL |
|--------|-------|-----|
| **Midjourney Showcase** | Official picks | https://midjourney.com/showcase |
| **MJ Prompt Tool** | Prompt explorer | https://prompt.noonshot.com |
| **Midlibrary** | Style library | https://midlibrary.io |

### Stable Diffusion
| Source | Focus | URL |
|--------|-------|-----|
| **Civitai** | Models, LoRAs, images | https://civitai.com |
| **PromptBase** | Prompt marketplace | https://promptbase.com |
| **Hugging Face** | Models + demos | https://huggingface.co/spaces |

### DALL-E & Others
| Source | Focus | URL |
|--------|-------|-----|
| **DALL-E Gallery** | OpenAI examples | https://labs.openai.com |
| **Ideogram** | Text-in-image AI | https://ideogram.ai |
| **Leonardo.AI** | AI art platform | https://leonardo.ai |

## Visual Design

### Designer Portfolios
| Source | Focus | Cost | URL |
|--------|-------|------|-----|
| **Dribbble** | Shots and portfolios | Free | https://dribbble.com |
| **Behance** | Full projects | Free | https://behance.net |
| **Layers** | Design portfolios | Free | https://layers.to |
| **Cofolios** | Design portfolios | Free | https://cofolios.com |
| **Bestfolios** | Portfolio showcase | Free | https://www.bestfolios.com |

### Curated Design
| Source | Focus | URL |
|--------|-------|-----|
| **Muzli** | Design news/inspo | https://muz.li |
| **Designspiration** | Visual search | https://designspiration.com |
| **Abduzeedo** | Design blog | https://abduzeedo.com |
| **Design Milk** | Design culture | https://design-milk.com |
| **It's Nice That** | Creative showcase | https://itsnicethat.com |

### Mood Boards
| Source | Focus | URL |
|--------|-------|-----|
| **Pinterest** | Visual boards | https://pinterest.com |
| **Are.na** | Creative research | https://are.na |
| **Savee** | Visual bookmarking | https://savee.it |
| **Cosmos** | Visual inspiration | https://www.cosmos.so |

## Colors & Palettes

### Palette Generators
| Source | Focus | URL |
|--------|-------|-----|
| **Coolors** | Random + lock colors | https://coolors.co |
| **Adobe Color** | Color wheel + extract | https://color.adobe.com |
| **Paletton** | Color scheme designer | https://paletton.com |
| **Colormind** | AI palette generator | https://colormind.io |
| **Huemint** | AI brand colors | https://huemint.com |

### Curated Palettes
| Source | Focus | URL |
|--------|-------|-----|
| **Color Hunt** | User-submitted palettes | https://colorhunt.co |
| **Happy Hues** | Palettes in context | https://happyhues.co |
| **Culrs** | Minimal palettes | https://culrs.com |
| **Palette List** | Hex palettes | https://palettelist.com |
| **Grabient** | Gradient palettes | https://grabient.com |

### From Images/Keywords
| Source | Focus | URL |
|--------|-------|-----|
| **Picular** | Colors from words | https://picular.co |
| **Image Color Picker** | Extract from image | https://imagecolorpicker.com |
| **Palette Generator** | From photos | https://palettegenerator.com |
| **Realtime Colors** | See palette on UI | https://realtimecolors.com |

### Gradients
| Source | Focus | URL |
|--------|-------|-----|
| **WebGradients** | 180 gradients | https://webgradients.com |
| **UI Gradients** | Gradient collection | https://uigradients.com |
| **Gradient Hunt** | Curated gradients | https://gradienthunt.com |
| **Mesh Gradients** | Mesh gradient tool | https://meshgradient.in |
| **Grainy Gradients** | Noise gradients | https://grainy-gradients.vercel.app |

## Typography

### Font Discovery
| Source | Focus | URL |
|--------|-------|-----|
| **Typewolf** | Font recommendations | https://typewolf.com |
| **Fonts In Use** | Real-world typography | https://fontsinuse.com |
| **Typographica** | Type reviews | https://typographica.org |
| **I Love Typography** | Type blog | https://ilovetypography.com |

### Font Pairing
| Source | Focus | URL |
|--------|-------|-----|
| **Font Pair** | Google Font combos | https://fontpair.co |
| **Fontjoy** | AI font pairing | https://fontjoy.com |
| **Archetype** | Font pairing tool | https://archetypeapp.com |
| **Typ.io** | Font combos in use | https://typ.io |

### Free Fonts
| Source | Focus | URL |
|--------|-------|-----|
| **Google Fonts** | Open source fonts | https://fonts.google.com |
| **Font Share** | Quality free fonts | https://fontshare.com |
| **Font Squirrel** | Commercial-free fonts | https://fontsquirrel.com |
| **The League of Moveable Type** | Open type | https://theleagueofmoveabletype.com |
| **Uncut** | Variable fonts | https://uncut.wtf |

### Premium Fonts
| Source | Focus | URL |
|--------|-------|-----|
| **MyFonts** | Largest marketplace | https://myfonts.com |
| **Adobe Fonts** | With CC subscription | https://fonts.adobe.com |
| **Pangram Pangram** | Modern foundry | https://pangrampangram.com |
| **Klim Type** | Quality foundry | https://klim.co.nz |
| **Colophon** | Type foundry | https://colophon-foundry.org |

## Icons

### Icon Sets
| Source | Focus | URL |
|--------|-------|-----|
| **Heroicons** | Tailwind default | https://heroicons.com |
| **Lucide** | Fork of Feather | https://lucide.dev |
| **Feather** | Minimal icons | https://feathericons.com |
| **Phosphor** | Flexible family | https://phosphoricons.com |
| **Tabler Icons** | 3000+ free | https://tabler-icons.io |
| **Bootstrap Icons** | Bootstrap set | https://icons.getbootstrap.com |
| **Ionicons** | Ionic icons | https://ionic.io/ionicons |

### Icon Search
| Source | Focus | URL |
|--------|-------|-----|
| **Noun Project** | 5M+ icons | https://thenounproject.com |
| **Flaticon** | Largest database | https://flaticon.com |
| **Iconify** | Unified search | https://icon-sets.iconify.design |
| **SVG Repo** | Free SVG icons | https://svgrepo.com |
| **Icons8** | Icons + illustrations | https://icons8.com |

### Animated Icons
| Source | Focus | URL |
|--------|-------|-----|
| **Lordicon** | Animated icons | https://lordicon.com |
| **useAnimations** | Lottie icons | https://useanimations.com |
| **IconScout** | 3D + animated | https://iconscout.com |

## Illustrations

### Free Illustrations
| Source | Focus | URL |
|--------|-------|-----|
| **unDraw** | Customizable SVG | https://undraw.co |
| **Illustrations.co** | Open source | https://illlustrations.co |
| **Open Doodles** | Hand-drawn | https://opendoodles.com |
| **Humaaans** | Mix-and-match people | https://humaaans.com |
| **Open Peeps** | Character builder | https://openpeeps.com |
| **Glaze** | Free illustrations | https://glaze.pm |

### Premium / Freemium
| Source | Focus | URL |
|--------|-------|-----|
| **Blush** | Customizable sets | https://blush.design |
| **Storyset** | Animated + static | https://storyset.com |
| **DrawKit** | MIT licensed | https://drawkit.com |
| **Absurd** | Surreal style | https://absurd.design |
| **Control** | 3D illustrations | https://control.rocks |

### 3D Assets
| Source | Focus | URL |
|--------|-------|-----|
| **Sketchfab** | 3D model viewer | https://sketchfab.com |
| **Poly Pizza** | Low-poly 3D | https://poly.pizza |
| **3D Icons** | 3D icon sets | https://3dicons.co |
| **Shapefest** | 3D shapes | https://shapefest.com |

## Motion & Animation

### Animation References
| Source | Focus | URL |
|--------|-------|-----|
| **UI Movement** | UI animations | https://uimovement.com |
| **Lottie Files** | JSON animations | https://lottiefiles.com |
| **GSAP Showcase** | GSAP examples | https://gsap.com/showcase |
| **CodePen** | Live code examples | https://codepen.io |

### Motion Tools
| Source | Focus | URL |
|--------|-------|-----|
| **Rive** | Interactive animations | https://rive.app |
| **Jitter** | Motion design tool | https://jitter.video |
| **Fable** | Collaborative motion | https://fable.app |
| **Haiku** | Animation IDE | https://haikuforteams.com |

### Tutorials
| Source | Focus | URL |
|--------|-------|-----|
| **MotionDesign.School** | Motion courses | https://motiondesign.school |
| **School of Motion** | Animation education | https://schoolofmotion.com |
| **Cubic Bezier** | Easing visualizer | https://cubic-bezier.com |

## Branding

### Logo Inspiration
| Source | Focus | URL |
|--------|-------|-----|
| **Logopond** | Logo gallery | https://logopond.com |
| **Logo Lounge** | Logo trends | https://logolounge.com |
| **Logggos** | Logo collection | https://logggos.club |
| **Logo Design Love** | Logo blog | https://logodesignlove.com |
| **Logospire** | Logo inspiration | https://logospire.com |

### Brand Guidelines
| Source | Focus | URL |
|--------|-------|-----|
| **Brand Style Guide** | Real examples | https://brandstyleguide.com |
| **Guidelines** | Brand assets | https://guidelines.design |
| **Find Guidelines** | Guideline search | https://findguidelines.com |

## Tools & Resources

### Design Tools
| Tool | Purpose | URL |
|------|---------|-----|
| **Figma** | UI design | https://figma.com |
| **Framer** | Prototyping | https://framer.com |
| **Webflow** | Visual dev | https://webflow.com |
| **Spline** | 3D design | https://spline.design |

### Browser Extensions
| Extension | Purpose |
|-----------|---------|
| **Muzli** | New tab inspo |
| **ColorZilla** | Color picker |
| **WhatFont** | Font identifier |
| **Full Page Screenshot** | Capture pages |

### AI Tools
| Tool | Purpose | URL |
|------|---------|-----|
| **Galileo AI** | UI generation | https://galileo-ai.com |
| **Uizard** | Wireframe to UI | https://uizard.io |
| **Khroma** | AI color tool | https://khroma.co |
| **Magician** | Figma AI plugin | https://magician.design |
