# Changelog

All notable changes to the polymarket-api skill will be documented in this file.

## [2.0.0] - 2026-03-03

### Changed
- ✅ **Major Refactor**: Converted from trading-specific to general API guide
- ✅ Removed arbitrage-specific scripts and strategies
- ✅ Updated all documentation to be educational/reference focused
- ✅ Changed focus from "trading bot" to "API data access guide"

### Added
- ✅ `examples/realtime_data.py` - WebSocket and Socket.IO examples
- ✅ `examples/polling.py` - Polling methods and fallbacks
- ✅ `examples/orderbook.py` - Order book access and analysis
- ✅ `references/API_REFERENCE.md` - Complete API endpoint documentation
- ✅ `references/WEBSOCKET_GUIDE.md` - WebSocket implementation guide

### Updated
- ✅ `README.md` - Now reflects general API guide (not trading strategy)
- ✅ `SKILL.md` - General API documentation (already done)
- ✅ `skill.json` - Updated author, description, and tags
- ✅ `requirements.txt` - Updated dependencies

### Removed
- ✅ `scripts/` directory - Removed strategy-specific scripts
- ✅ `examples/basic_arbitrage.py` - Removed arbitrage example
- ✅ `references/ARBITRAGE_STRATEGY.md` - Removed strategy doc

### Documentation
- 📝 All examples now educational and generic
- 📝 No trading strategies mentioned
- 📝 Focus on HOW to use APIs, not WHAT to build

---

## [1.0.0] - 2026-03-03 (Legacy)

### Note
Version 1.0.0 was a trading-focused release. It has been superseded by version 2.0.0 which is a general API guide.

---

## Version History

| Version | Date | Status | Key Features |
|---------|------|--------|-------------|
| 2.0.0 | 2026-03-03 | ✅ Current | General API guide, educational examples |
| 1.0.0 | 2026-03-03 | ❌ Deprecated | Trading-focused (replaced by 2.0.0) |

---

[2.0.0]: https://clawhub.ai/skills/polymarket-api/v/2.0.0
