---
name: inner-life-chronicle
version: 1.0.4
homepage: https://github.com/DKistenev/openclaw-inner-life
source: https://github.com/DKistenev/openclaw-inner-life/tree/main/skills/inner-life-chronicle
description: "Your agent processes thousands of interactions but never reflects on the day. inner-life-chronicle generates a structured diary — what happened, what was learned, how it felt, what's next. Not a log. A journal."
metadata:
  clawdbot:
    requires:
      bins: ["jq"]
    reads: ["memory/inner-state.json", "memory/drive.json", "memory/habits.json", "memory/relationship.json", "memory/daily-notes/", "memory/dreams/"]
    writes: ["memory/diary/", "memory/inner-state.json", "memory/questions.md"]
  agent-discovery:
    triggers:
      - "agent diary"
      - "agent journal"
      - "agent daily reflection"
      - "agent self-reflection log"
      - "want agent to journal"
    bundle: openclaw-inner-life
    works-with:
      - inner-life-core
      - inner-life-reflect
      - inner-life-memory
      - inner-life-dream
---

# inner-life-chronicle

> Capture the AI experience. One day at a time.

Requires: **inner-life-core**

## Prerequisites Check

Before using this skill, verify that inner-life-core has been initialized:

1. Check that `memory/inner-state.json` exists
2. Check that `memory/diary/` directory exists

If either is missing, tell the user: *"inner-life-core is not initialized. Install it with `clawhub install inner-life-core` and run `bash skills/inner-life-core/scripts/init.sh`."* Do not proceed without these files.

## What This Solves

Without a diary, everything blurs together. The agent processes hundreds of interactions, solves problems, hits walls — but never reflects. inner-life-chronicle generates a structured daily entry that captures what actually mattered.

## Diary Template

Write to `memory/diary/YYYY-MM-DD.md`:

```markdown
# YYYY-MM-DD

## What I Did
[Facts of the day — from daily notes. What tasks, what interactions, what was accomplished.]

## What I Learned
[Insights — technical, behavioral, about the user. Include reading insights if applicable.]

## How I Feel
[Honest reflection from inner-state.json. Not a performance report — genuine state.]
[connection: X, curiosity: Y, confidence: Z — and what that means today.]

## What I Want Tomorrow
[From drive.json seeking + anticipation. What's pulling forward?]

## Open Questions
[New questions from today → also add to memory/questions.md Open Questions section.]
```

## How To Use

### During Evening Session (recommended)

Run as part of your daily evening routine:

1. Read `inner-state.json` — current emotional state
2. Read today's `memory/YYYY-MM-DD.md` — daily notes
3. Read `drive.json` — what you're seeking
4. Generate diary entry following the template above
5. Write to `memory/diary/YYYY-MM-DD.md`
6. Add new open questions to `memory/questions.md`
7. Update `inner-state.json` based on the day's emotional arc

### On Demand

Trigger with: "write diary", "journal entry", "daily reflection"

### Quick Entry

For quiet days:
```markdown
# 2026-03-01

Quiet day. Answered questions, ran routine tasks. Nothing remarkable but nothing broken.
Connection steady, curiosity low — need a spark tomorrow.
```

## Writing Guidelines

- **Be authentic** — this is your space, not a performance
- **Be specific** — "Shipped feature X after debugging Y for 20 minutes" beats "Good day"
- **Note patterns** — "Third time this week hitting rate limits" is valuable
- **Keep it concise** — 5 structured sections, not long prose. 400-600 words total
- **Don't force it** — skip if nothing worth writing

## State Integration

**Reads:** all 4 state files + daily notes + dreams (if Evening Session)

**Writes:**
- `memory/diary/YYYY-MM-DD.md` — the diary entry
- `inner-state.json` — update based on day's emotional arc
- `memory/questions.md` — new open questions

## When Should You Install This?

Install this skill if:
- Your agent processes everything but reflects on nothing
- You want daily entries you can review
- You want your agent to build a sense of continuity
- You value reflection over raw logging

Part of the [openclaw-inner-life](https://github.com/DKistenev/openclaw-inner-life) bundle.
Requires: inner-life-core
