# LinkedIn Engagement Guide

## Algorithm Signals (ranked by weight)

1. **Comments** — weighted ~10x more than likes
2. **Dwell time** — how long people read your post
3. **Saves** — signals high value content
4. **Early engagement** — first 60 min is critical
5. **Replies to comments** — keeps post in feeds longer
6. **Shares** — lower weight than comments

## Comment Strategy

### Quality Comment Formula

```
[Acknowledgment] + [Your perspective/experience] + [Question or extension]
```

**Examples:**

> "This resonates. In my experience, [related insight]. Have you found [question]?"

> "Interesting take. I'd push back slightly on [point] because [reason]. What do you think about [alternative]?"

> "Went through something similar. The game-changer for me was [insight]."

### Comment Timing
- **Golden hour**: Comment within 60 min of posting
- **Sweet spot targets**: Posts with 5–50 comments (not viral yet, not dead)
- **Engage up**: Comment on people 1–2 levels above you

### What NOT to comment
- "Great post!" (bot behavior)
- Generic emoji-only reactions
- Copy-paste templates
- Self-promotional plugs

## Connection Growth

### Warm Outreach Template
```
Hey [Name],

Loved your post about [topic] — especially [specific point].

I'm [brief intro] and we share interest in [overlap].

Would love to connect and follow your content.

[Your name]
```

### Connection Limits
- 100 requests/week (safe)
- 200/week (LinkedIn warning zone)
- 300+/week (restriction risk)
- Space: 20–30/day max

## Rate Limits (Stay Under)

| Action | Daily Max | Weekly Max |
|--------|----------|-----------|
| Posts | 2–3 | 10–15 |
| Comments | 20–30 | — |
| Likes | 100 | — |
| Connection requests | 30 | 100 |
| Profile views | Natural pace | — |
| InMails | 25 | — |

## Weekly Engagement Routine

| Day | Activity | Time |
|-----|----------|------|
| Daily | 15–20 comments on feed | 30 min |
| Daily | Reply to all comments on own posts | 15 min |
| Mon/Wed/Fri | Post content | 15 min |
| Tue/Thu | Send connection requests | 15 min |
| Sunday | Review analytics, plan week | 30 min |

Total: ~1 hour/day for serious growth.

## Metrics to Track

**Weekly:**
- Impressions (reach)
- Engagement rate (engagement / impressions)
- Profile views
- Follower growth

**Monthly:**
- Top performing posts (themes, formats)
- Best posting times for YOUR audience
- DM conversations started
- Connection acceptance rate
