# LinkedIn Content Strategy

## Hook Mastery

First line is everything — LinkedIn truncates after ~140 chars.

**Strong hooks:**
- "I got fired yesterday." (shock)
- "Stop doing [common practice]." (contrarian)
- "The best advice I ignored for 5 years:" (curiosity)
- "Unpopular opinion:" (debate trigger)
- Direct statement + emoji for pattern interrupt

**Weak hooks (avoid):**
- "I'm excited to announce..."
- "Happy to share..."
- "Check out this article..."

## Post Structure

```
Hook line (grab attention)

Short paragraph (context)

• Bullet point 1
• Bullet point 2
• Bullet point 3

One-liner insight

Call to action or question
```

**Character counts:**
- Ideal post: 1,200–1,500 characters
- Max before "see more": ~140 characters
- Max total: 3,000 characters

## Best Posting Times (CET/CEST)

| Region | Best Times | Best Days |
|--------|-----------|-----------|
| DACH | 07:00–09:00 | Di–Do |
| US East | 13:00–15:00 | Di–Do |
| US West | 16:00–18:00 | Di–Do |
| Global | 08:00–09:00 CET | Di–Mi |

Rule: Post when your audience starts their workday.

## Content Pillars

Pick 3–4 and rotate:

1. **Educational** — Tips, how-tos, frameworks
2. **Personal Stories** — Failures, lessons, wins
3. **Industry Insights** — Trends, analysis, predictions (AI, digital transformation)
4. **Engagement Posts** — Questions, polls, debates

Example rotation:
- Monday: Educational
- Wednesday: Personal Story
- Friday: Engagement/Question

## The 4-1-1 Rule

For every 6 posts:
- 4 educational/value posts
- 1 soft promotion (case study, achievement)
- 1 hard promotion (product, service, hiring)

## Hashtag Strategy

- Use 3–5 hashtags at END of post
- Mix reach levels:
  - 1 broad (#leadership, #ai — 10M+ followers)
  - 2 medium (#digitaltransformation, #aistrategy — 1M)
  - 1–2 niche (#creditrisk, #fintechleadership — 50K)

## Post Formats That Perform

| Format | Engagement | Best For |
|--------|-----------|----------|
| Carousel/PDF | Very high | Frameworks, step-by-step |
| Poll | High | Quick engagement boost |
| Text-only | High | Stories, opinions |
| Image + text | Medium-high | Visual concepts |
| Link posts | Low | Driving traffic (algorithm deprioritizes) |
| Video | Variable | Personal brand, tutorials |

## Engagement Multipliers

- **Reply to every comment** within 1 hour = 2x reach
- **Tag 1–2 people** only if genuinely relevant
- **First comment strategy**: Add context/link in your own first comment
- **Cross-promote**: Share to Twitter/X, repurpose top posts
