# Platform-Specific Guidelines

## Platform Comparison

| Platform | Best For | Monetization | AI Acceptance |
|----------|----------|--------------|---------------|
| TikTok | Viral reach, Gen Z | Low (fund) | Moderate (needs disclosure) |
| Instagram | Brand deals, millennials | High | Moderate |
| YouTube | Long-term, search | Very High | Varies |
| Twitter/X | Commentary, tech niche | Low | Permissive |
| LinkedIn | B2B, professional | Growing | Low tolerance |

---

## TikTok Strategy

### Content Format
- **Duration:** 15-60 seconds optimal
- **Aspect:** 9:16 (1080×1920)
- **Hook:** First 1-3 seconds critical
- **Captions:** Built-in or burned in
- **Sound:** Use trending audio when possible

### Algorithm Tips
- Post 2-3x daily
- Engage in first hour after posting
- Use trending sounds/hashtags
- Reply to comments with videos
- Duet/Stitch popular content

### AI Disclosure
- Label AI content clearly
- Use #AIGenerated or #VirtualInfluencer
- Don't claim to be a real person
- May get flagged without disclosure

---

## Instagram Strategy

### Content Mix
```
Feed posts: 20%
Reels: 50%
Stories: 30%
```

### Format Specs
| Type | Size | Duration |
|------|------|----------|
| Feed (square) | 1080×1080 | Static |
| Feed (portrait) | 1080×1350 | Static |
| Reels | 1080×1920 | Up to 90s |
| Stories | 1080×1920 | 15s each |
| Carousel | 1080×1080/1350 | Up to 10 slides |

### Best Practices
- Reels for reach, Feed for brand
- Carousels for saves
- Stories for engagement
- Go Live occasionally (tricky for AI)
- Hashtags: 15-25 per post

### AI Considerations
- May be required to label AI content
- Brand partners may require disclosure
- Algorithm may deprioritize labeled AI content

---

## YouTube Strategy

### Content Types
- **Shorts:** 60s vertical, reach
- **Long-form:** 8-15 min, revenue
- **Community posts:** Engagement

### Format Specs
| Type | Size | Duration |
|------|------|----------|
| Long-form | 1920×1080 | 8-15 min optimal |
| Shorts | 1080×1920 | Up to 60s |
| Thumbnail | 1280×720 | — |

### SEO Optimization
- Keyword-rich titles
- Detailed descriptions
- Tags (still matter somewhat)
- Chapters for navigation
- End screens and cards

### AI Considerations
- Must disclose altered/synthetic content in some cases
- Talking head works well
- Faceless content also valid option
- Higher scrutiny on monetized content

---

## Twitter/X Strategy

### Content Types
- Text posts (opinions, hot takes)
- Quote tweets (commentary)
- Threads (in-depth content)
- Images/videos (engagement)

### Best Practices
- Tweet 5-10x daily
- Engage with larger accounts
- Quote tweet > retweet
- Hot takes drive engagement
- Threads for authority

### AI Considerations
- Most permissive platform
- Still should disclose if asked
- Tech/AI niche audiences accepting
- Character limit forces conciseness

---

## Cross-Platform Strategy

### Content Flow
```
Long-form YouTube video
    ↓
Cut into TikTok/Reels clips (5-10)
    ↓
Quote cards for Twitter (10+)
    ↓
Carousel for Instagram (1-2)
    ↓
Thread for Twitter (1)
    ↓
Stories teasing each piece
```

### Platform Priorities by Goal

**Maximum reach:** TikTok → Reels → YouTube Shorts
**Brand deals:** Instagram → TikTok → YouTube
**Revenue:** YouTube → Instagram → TikTok
**Authority:** LinkedIn → YouTube → Twitter

---

## Scheduling Tools

| Tool | Platforms | AI-Friendly |
|------|-----------|-------------|
| Later | IG, TikTok, Pinterest, Twitter | Yes |
| Hootsuite | All major | Yes |
| Buffer | All major | Yes |
| Creator Studio | Meta only | Yes |
| TikTok Native | TikTok only | Yes |

### Posting Times (General)
- **TikTok:** 7-9am, 12-3pm, 7-9pm
- **Instagram:** 6-9am, 12-2pm, 5-8pm
- **YouTube:** 2-4pm weekdays
- **Twitter:** 8-10am, 12-1pm

*Adjust based on audience location and analytics*

---

## Platform-Specific Disclosures

### TikTok
```
AI-generated content | #VirtualInfluencer
```

### Instagram
```
✨ AI-generated content | Created with AI tools
#AIInfluencer #VirtualCreator
```

### YouTube
```
[In description]
This video features AI-generated content.
```

### Twitter
```
🤖 AI-generated persona
```

---

## Growth Tactics by Platform

### TikTok
1. Post during trending sound windows
2. Participate in challenges immediately
3. Duet with larger creators
4. Reply to comments with videos
5. Go niche initially, then expand

### Instagram
1. Collaborate with similar accounts
2. Share to Reels from TikTok (remove watermark)
3. Use Stories polls/questions
4. Engage in niche hashtag communities
5. Optimize bio for search

### YouTube
1. Strong thumbnails (faces work best)
2. First 30 seconds = hook retention
3. End screens drive subscriptions
4. Comment on larger channels
5. Playlist optimization

### Twitter
1. Engage with popular accounts in niche
2. Quote tweet with valuable additions
3. Thread game (numbered threads)
4. Hot takes during events
5. Build relationships with other creators
