# Persona Creation Guide

## Identity Template

Create `identity.md` in the persona folder:

```markdown
# {Name}

## Basic Info
- **Name:** 
- **Age:** 
- **Location:** (city, country)
- **Occupation:** (what they "do" in their narrative)

## Niche & Positioning
- **Primary niche:** (fitness, fashion, tech, lifestyle, etc.)
- **Sub-niches:** (vegan, minimalist, luxury, budget, etc.)
- **Target audience:** (demographics, interests)
- **Unique angle:** (what makes them different)

## Personality
- **Voice:** (confident, relatable, educational, funny, etc.)
- **Values:** (sustainability, authenticity, ambition, etc.)
- **Catchphrases:** (signature expressions)
- **Emoji style:** (which emojis, how often)

## Visual Identity
- **Aesthetic:** (clean, moody, colorful, minimalist)
- **Color palette:** (2-3 dominant colors)
- **Settings:** (gym, apartment, outdoors, studio)
- **Style:** (athleisure, streetwear, elegant, casual)

## Backstory (for consistency)
Brief narrative: where they grew up, how they got into their niche, what drives them. Used for Q&As and "personal" content.
```

---

## Niche Selection Matrix

| Niche | Monetization | Competition | Content Difficulty |
|-------|--------------|-------------|-------------------|
| Fitness | High (supps, programs) | Very high | Medium (need gym/outdoors) |
| Fashion | High (affiliates) | Very high | High (outfits, shoots) |
| Tech | High (affiliates) | Medium | Low (can be faceless) |
| Lifestyle | Medium | Very high | Medium |
| Finance | Very high | Medium | Low (talking head works) |
| Gaming | Medium | High | Low (screen content) |
| Travel | Medium (when monetized) | High | High (locations) |
| Cooking | Medium | Medium | Medium (kitchen setup) |

---

## Reference Image Generation

Generate initial reference set with these prompts:

**Base portrait (front):**
```
Portrait photo of [age] year old [ethnicity] [gender], [hair description], [eye color], [skin tone], [expression], professional photography, soft lighting, neutral background, 4K
```

**Variations to generate:**
1. Front portrait, neutral expression
2. Front portrait, smiling
3. 3/4 view, left side
4. 3/4 view, right side
5. Full body, standing
6. Action shot (relevant to niche)
7. Casual setting (home/outdoor)
8. Professional setting (if applicable)

**Save all to `reference/` folder with descriptive names.**

---

## Consistency Anchors

Define these and NEVER change them:

1. **Face structure** — locked by reference images
2. **Hair color/style** — keep consistent (can "change" as content)
3. **Body type** — consistent proportions
4. **Skin tone** — same across all lighting
5. **Eye color** — never changes
6. **Voice** — same TTS voice/settings always

---

## Persona Evolution Rules

What CAN change over time (like real influencers):
- Hairstyle (announce it as a "new look")
- Fashion style (gradual evolution)
- Topics covered (expanding into related niches)
- Aesthetic (seasonal adjustments)

What NEVER changes:
- Face structure
- Body proportions
- Eye color
- Core personality traits
- Voice

---

## Name Generation Tips

Good AI influencer names:
- Sound natural (avoid obviously fake names)
- Easy to spell and search
- Available as handle on target platforms
- Match cultural background of the persona
- Not too close to real celebrities

Check availability on: Instagram, TikTok, Twitter/X, YouTube before finalizing.
