# Content Strategy for AI Influencers

## Content Pillars

Every influencer needs 3-4 content pillars:

| Pillar Type | Purpose | % of Content |
|-------------|---------|--------------|
| **Educational** | Establish authority | 30-40% |
| **Entertaining** | Engagement, shares | 30-40% |
| **Personal** | Build connection | 20-30% |
| **Promotional** | Monetization | 10-20% |

**Example (Fitness Influencer):**
- Educational: Workout tips, nutrition facts
- Entertaining: Transformation content, challenges
- Personal: "Day in my life", struggles, wins
- Promotional: Supplement reviews, program launches

---

## Caption Templates

### Hook Types
```
"Stop doing [thing] wrong..."
"The truth about [topic] that no one talks about"
"I was today years old when I learned..."
"POV: you finally [desired outcome]"
"Unpopular opinion: [controversial take]"
"[Number] things I wish I knew before [action]"
```

### Educational Post
```
[Hook that identifies pain point]

Here's what actually works:

1. [First tip with explanation]
2. [Second tip with explanation]
3. [Third tip with explanation]

Save this for later! ✨

#[niche] #[subtopic] #tips
```

### Personal/Story Post
```
Real talk for a sec... 💭

[Vulnerable opening about struggle/experience]

[What you learned/how you overcame]

[Encouraging message to audience]

Anyone else been through this? Drop a 🙋 below

#[niche] #reallife #motivation
```

### Promotional Post (with disclosure)
```
#ad | Partnering with @brand

[Genuine hook about the product]

[Your experience using it]

[Specific benefit that resonates with audience]

[CTA: Link in bio / Use code X for discount]

#[brand] #[niche] #sponsored
```

---

## Hashtag Strategy

### Structure
```
5 high-volume hashtags (1M+ posts)
10 medium-volume (100K-1M)
5 niche-specific (10K-100K)
3-5 branded/custom
```

### Research Process
1. Search competitors' successful posts
2. Check hashtag volumes on platform
3. Mix trending + evergreen tags
4. Create branded hashtag for community

### Avoid
- Banned/restricted hashtags
- Irrelevant high-volume tags
- Only broad hashtags

---

## Content Calendar Template

Store in `schedule.md`:

```markdown
# Week of [Date]

## Monday
- **Type:** Educational
- **Topic:** [specific topic]
- **Platform:** IG + TikTok
- **Time:** 11am ET
- **Assets needed:** Image + caption

## Tuesday
- **Type:** Personal
- **Topic:** Story time about [experience]
- **Platform:** TikTok only
- **Time:** 6pm ET
- **Assets needed:** Talking head video

[Continue for week...]
```

---

## Posting Frequency by Platform

| Platform | Minimum | Optimal | Maximum |
|----------|---------|---------|---------|
| TikTok | 1/day | 2-3/day | 5/day |
| IG Feed | 3/week | 1/day | 2/day |
| IG Stories | 3/day | 5-10/day | 15/day |
| IG Reels | 3/week | 1/day | 3/day |
| YouTube Shorts | 3/week | 1/day | 3/day |
| YouTube Long | 1/week | 2/week | 5/week |
| Twitter/X | 3/day | 5-10/day | 20/day |

---

## Engagement Tactics

### Increase Comments
- Ask questions in caption
- "Comment [word] for [thing]"
- "Which one are you? A or B?"
- Controversial takes that invite debate

### Increase Saves
- Valuable tips/tutorials
- "Save this for later"
- Lists and templates
- Reference content

### Increase Shares
- Relatable content
- Humor
- "Tag someone who..."
- Controversial opinions

---

## Trending Content Adaptation

When a trend appears:

1. **Assess fit** — Does it match persona?
2. **Speed matters** — Post within 24-48 hours
3. **Add unique spin** — Don't copy exactly
4. **Use trending audio** (TikTok/Reels)
5. **Maintain brand** — Stay in character

---

## Content Repurposing

One piece of content → Multiple platforms:

```
Long YouTube video
  → Cut into 5 Shorts
  → Extract 10 quotes for Twitter
  → Create carousel from key points
  → Pull audio for podcast
```

---

## Performance Tracking

Log in `analytics.md`:

```markdown
# Week of [Date]

## Top Performer
- **Post:** [link/description]
- **Views:** X
- **Engagement:** X%
- **Why it worked:** [analysis]

## Learning
- [What to do more of]
- [What to stop doing]
- [Tests to run next week]

## Metrics
| Metric | This Week | Last Week | Change |
|--------|-----------|-----------|--------|
| Followers | | | |
| Avg views | | | |
| Engagement rate | | | |
| Profile visits | | | |
```

---

## Content Ideas Generator

When stuck, generate content around:

1. **Myths** — "5 myths about [niche] busted"
2. **Mistakes** — "Biggest mistakes I made..."
3. **Tools** — "My [number] favorite [tools]"
4. **Day in life** — "What I actually do in a day"
5. **Transformations** — Before/after anything
6. **Reactions** — React to trending topics
7. **Duets/Stitches** — Respond to viral content
8. **Q&A** — Answer audience questions
9. **Tutorials** — Step-by-step how-tos
10. **Hot takes** — Controversial opinions
