# Legal & Compliance for AI Influencers

## ⚠️ Critical Disclosure Requirements

### FTC Guidelines (USA)
AI-generated influencers MUST disclose:
- **#AIGenerated** or **#VirtualInfluencer** in visible location
- **Clear statement** that content is AI-generated
- **Sponsored content** disclosed same as human influencers

**Placement rules:**
- Beginning of caption (not buried)
- In video itself (not just description)
- Visible without clicking "more"

### EU AI Act (Europe)
- AI-generated content must be labeled
- Deepfakes require clear identification
- More stringent than US requirements

### Platform Requirements

| Platform | Requirement |
|----------|-------------|
| TikTok | Label AI-generated content, no deceptive AI |
| Instagram | Disclosure in posts, Stories exempt for now |
| YouTube | Check "altered/synthetic" in upload if applicable |
| Twitter/X | No specific AI disclosure yet (subject to change) |

---

## What IS and ISN'T Allowed

### ✅ Allowed
- Creating fictional AI personas
- AI-generated lifestyle content
- Sponsored posts with proper disclosure
- Educational content
- Entertainment content

### ❌ Prohibited
- Claiming AI influencer is a real person
- Using real person's likeness without consent
- Generating content that impersonates public figures
- Age-restricted content without verification
- Misleading claims about products (same as real influencers)

---

## Face/Likeness Rules

### Using Generated Faces
✅ Safe — fully AI-generated faces with no resemblance to real people
✅ Safe — licensed stock model faces as reference
⚠️ Risky — faces that closely resemble celebrities
❌ Illegal — using real person's face without consent

### Training Data Considerations
- Don't train LoRAs on copyrighted images without license
- Don't train on real people without consent
- Keep records of what data was used

---

## Sponsored Content Rules

AI influencers follow SAME rules as human influencers:

1. **#Ad or #Sponsored** clearly visible
2. **"Paid partnership"** tag if available
3. **No fake reviews** or misleading claims
4. **Material connection** must be disclosed
5. **FTC Endorsement Guidelines** fully apply

---

## Copyright & IP

### Your Content
- You own generated images (check tool TOS)
- Scripts you write are yours
- Voice clones: depends on source audio rights

### Third-Party Content
- Music: must be licensed or royalty-free
- Stock footage: verify license covers AI/synthetic use
- Brands: get permission before using logos

### Platform TOS
Each platform has specific AI content rules:
- TikTok: no deceptive synthetic media
- Instagram: may require AI labels
- YouTube: must label synthetic content in certain cases

---

## Age-Related Content

### Minor Personas
⚠️ HIGH RISK — Do not create AI influencers that appear to be minors
- Legal issues across all jurisdictions
- Platform bans likely
- Reputational damage

### Adult Content
- Age verification required on platforms that allow it
- Many AI tools prohibit adult content generation
- Higher legal scrutiny

---

## Jurisdiction Considerations

AI influencer laws vary by country:

| Region | Strictness | Key Requirements |
|--------|------------|------------------|
| USA | Medium | FTC disclosure |
| EU | High | AI Act labeling |
| UK | Medium | ASA guidelines |
| China | Very High | AI registration |
| Japan | Low | Few specific rules |

**Best practice:** Follow the strictest rules (EU) to be safe globally.

---

## Documentation to Keep

Maintain records for each AI influencer:

1. **Creation documentation**
   - How face was generated
   - Training data sources
   - Voice clone source audio

2. **Disclosure evidence**
   - Screenshots of disclosures
   - Copy of all sponsored posts

3. **License documentation**
   - Tool licenses (Midjourney, ElevenLabs, etc.)
   - Music licenses
   - Stock asset licenses

---

## Risk Mitigation Checklist

For every post:
- [ ] AI disclosure present and visible
- [ ] No real person's likeness used
- [ ] Sponsored content disclosed if applicable
- [ ] Claims are truthful and verifiable
- [ ] Music/assets properly licensed
- [ ] Age-appropriate content
- [ ] Platform TOS compliant

---

## When in Doubt

1. **Add more disclosure**, not less
2. **Consult legal counsel** for commercial operations
3. **Check platform updates** (rules change frequently)
4. **Document everything** (shows good faith if issues arise)
