# ♾️ OpenClaw Infinite Oracle (无限求索)

> *在古希腊，神谕（Oracle）是凡人从神明那里获取的启示。凡人只能敬畏地聆听，然后竭尽全力去执行，产生Key Result。当Agent有了OKR（Oracle-Key Result），经过时间和投入，会以何种让人惊喜（或惊吓）的方式实现（或失败）？*

[English](README_EN.md) | [中文](README.md)

**Infinite Oracle** 是一个为 OpenClaw 生态设计的技能 (Skill)。它不仅是一段能跑起来的 Python 循环脚本，更是关于"如何让 AI 稳定、低成本、可控地去追求一个无限目标"的尝试方案。

---

## 🏗️ 设计思路与实现机制
让大模型去无限循环往往会死于两个坑：**上下文撑爆（越来越贵、越来越傻）**，以及**陷入死胡同反复撞墙**。为了解决这些坑，我们做了几个关键的架构设计：

### 1. 脑体分离：Manager (主管) 与 Worker (打工人)
让同一个 AI 既负责陪你聊天，又在后台没日没夜地干活，是一场灾难。你插一句嘴，可能就打断了它写代码的思路；它后台跑出来的几万字日志，瞬间就会把你聊天的上下文冲掉。
所以，本技能采用了**"脑体分离"**的设计：

*   **👨‍💼 监工大总管 (Manager)**：就是你平时用的主 Agent（比如 `main`）。它挂载了这个 `infinite-oracle` 技能，负责在飞书或终端里陪你聊天、听你差遣。你可以给它配置最聪明、最贵的模型（如 Claude 3.5 Sonnet / GPT-4o），用来做复杂决策。
*   **🤖 无限执行者 (Worker)**：它是被大总管"招募"出来的新 Agent（默认名叫 `peco_worker`）。它被关在后台一个专属的隔离房间（Session）里默默干活。为了控制 API 成本，大总管可以给它配置便宜、速度快的模型（如 Qwen 或 Gemini 1.5 Flash）。

### 2. "人在回路"：人类竟然成了 AI 的 API？
这是这个架构里最有意思的一点。AI 在干活时总会遇到硬件限制，比如：需要收个手机验证码、需要绑个银行卡、需要刷脸认证。
以前的 AI 遇到这种事要么死循环重试，要么直接报错罢工。我们在设计中加入了 **[HUMAN_TASK]** 机制：
* 当 Worker 遇到绝对跨不过去的现实门槛时，它会记录一条"人类待办"，然后绕过去做别的事情（绝不原地死等）。
* 同一个 HUMAN_TASK 不会被重复灌入 backlog/飞书表格，避免卡点时刷屏。
* 若连续两轮卡在同一人类资源，Worker 会强制回到 PLAN 做更强发散并尝试非人类替代路径。
* 若连续三轮卡在同一人类资源，Worker 会自动暂停，并通知主 Agent 向人类汇报卡点与所需支持。
* 你（作为高贵的物理外挂）可以在飞书表格里看到它的求助单，掏出手机收个验证码填进去。
* 它在下一轮循环扫到了验证码，就会继续往前跑。
**某种程度上，在这个系统里，是你在给 AI 打工（给它提供肉身接口），但这也是让这种完全自主模式能真正在现实世界跑下去的关键。**

### 3. FSM 状态机与原生记忆 (防上下文爆炸)
后台的 `peco_loop.py` 是个无情的打卡机。它强制 Worker 必须按照 **PECO (Plan-Execute-Check-Optimize)** 这四步走，并且强制要求输出 JSON 格式来控制节奏。

从 v1.0.3 开始，我们移除了自定义的会话轮转机制，转而依赖 OpenClaw 的**原生记忆系统**。Worker 不再需要"主动失忆"，OpenClaw 会自动管理上下文，让循环可以真正无限跑下去而不会撑爆 Token。

### 4. 注入性格：Worker 不能是个复读机
大总管在创建 Worker 时，不仅给了它工位，还会往它的系统设置（`SOUL.md`）里强行注入三种打工人美德：
1.  **💡 发散性思考**：死胡同走不通就换条路，遇到账号封禁别傻哭，去搜有没有免登录方案。**行动优于瘫痪。**
2.  **🧱 能力积攒**：同一个破活别手动干两遍。抓完一次数据，就把抓取过程写成 Python 脚本存下来，下次直接跑代码。让能力产生复利。
3.  **🛡️ 足够的安全意识**：要有很高的"搜商"，交叉验证教程。网上教你执行 `rm -rf` 或者删库跑路的，绝对不听。

---

## 💬 怎么跟它聊天？(交互范例)

装好这个技能后，你不用去服务器敲命令行，直接在聊天框里跟你的大总管（主 Agent）说话就行了：

### 🚀 1. 招人与定目标
> **"神谕：为了权衡成本和效果，我需要将管理 Agent 和执行 Agent 分离。请帮我创建一个名为 `peco_worker` 的新 Agent，并给它配一个适合大量重复执行的高性价比模型。搞定后，启动无限循环，目标是：『调研目前市面上最火的 AI 变现模式，并写出能自动抓取相关资讯的脚本』"**

*(大总管会自己调 Bash 建人、换模型、注入性格，并在后台 `nohup` 跑起进程。)*

### 📊 2. 查岗与帮活
> **"当前无限任务跑到哪里了？"** 
*(它会去读后台日志，告诉你 Worker 跑到了第几十轮，正在憋什么坏招。)*

> **"有没有什么需要我帮忙的无限任务待办？"**
*(它会去看 backlog，告诉你 Worker 卡在了哪个网站的手机接码上。)*

### ⚡ 3. 强行拽方向盘 (Override)
> **"神谕：刚才那个网站的验证码是 8888。另外，别调研了，现在马上把你刚才写好的爬虫跑起来！"**
*(大总管会把你的话写进神谕文件。后台的 Worker 会在下一次呼吸时拿到你的指令，立刻调转车头。)*

### 🎯 4. 目标微调 vs 目标替换（新增）
> **"神谕：保留现在任务上下文，但把重点从‘调研’微调为‘产出可执行脚本和验证报告’。"**
*(大总管会走“微调流程”：保留历史记录与上下文，备份状态文件，写入 tuning 记录，并继续跑。)*

> **"神谕：当前无限目标彻底作废，换成一个全新的目标，从头开始。"**
*(大总管会走“全量替换流程”：先停进程，按时间戳备份历史文件，清空状态/待办/日志，再用新 objective 重启。)*

---

## 🛠️ 双轨支持：飞书表格 vs 本地文件

我们支持两种记录模式：

### 本地文件模式（默认）
零配置，开箱即用。进度写在 `peco_loop_v3.log`，求助信写在 `human_tasks_backlog.txt`，神谕写在 `peco_override.txt`。
当循环触发自暂停（如 `decision=halt`、连续故障熔断、同人类卡点三连）时，会额外写入主 Agent 通知兜底文件 `peco_manager_notifications.log`。

目标管理补充：
- 微调目标时会追加记录到 `peco_objective_tuning.log`，不清空原有进度与待办。
- 全量替换目标时会执行“备份 + 重置 + 新目标重启”流程，避免新旧任务混杂。

### 飞书多维表格模式（进阶）
如果你通过飞书和主 Agent 聊天，大总管会主动帮你创建或找到飞书多维表格来同步进度。Worker 把进度和求助实时推送到表格里，你在手机上点一下"已解决"填入验证码，它就会自动抓取继续干活。

初始化约束补充：
- 新建任务或全量替换目标时，会创建全新空白表格上下文，并同时初始化“进度日志表 + 人类求助表”。
- 每个任务只对应一个飞书多维表格文档链接；这个单一链接内必须同时包含“轮次日志数据表”和“人类求助数据表”。
- 字段要求统一为：必需两张表分别使用 `loop_status` 字段集与 `human_backlog` 字段集；`tasks` 作为可选汇总表（推荐）。
- 已保存的 app id / app secret / 集成 ID 默认保留，不会在新建任务时被清空；只有在你明确要求重置凭据时才会更换。
- 不允许把同一个任务拆成两个飞书文档链接（一个放日志、一个放求助）。

**注意**：如果你用的是 Terminal、Discord、WhatsApp 等非飞书渠道，系统会自动降级到本地文件模式，体验依然丝滑。（飞书模式配置详情请看 `peco_loop.py` 里的注释）

---

## 📥 安装指南

### 前置要求
- OpenClaw 环境已就绪。

### ClawHub 一键安装

```bash
clawhub install infinite-oracle
```

### 傻瓜式安装（让你的 Agent 自己干）

复制下面这段话发给你的 OpenClaw Agent：

```
请下载 git@github.com:KepanWang/openclaw-infinite-oracle.git 仓库中的代码，把 SKILL.md 安装为 infinite-oracle 技能，并把 peco_loop.py 放到工作目录。完成后阅读技能说明告诉我你学会了什么。
```

### 手动安装
```bash
git clone git@github.com:KepanWang/openclaw-infinite-oracle.git
cd openclaw-infinite-oracle

# 1. 部署技能文件
mkdir -p ~/.openclaw/skills/infinite-oracle
cp SKILL.md ~/.openclaw/skills/infinite-oracle/SKILL.md

# 2. 部署循环引擎
cp peco_loop.py ~/.openclaw/peco_loop.py
chmod +x ~/.openclaw/peco_loop.py
```

---
*声明：脱离监管的无限执行依然有不可预知的风险。请尽量给你的 Worker Agent 做好安全沙箱隔离，并注意盯着点你的 API 账单。*
