---
name: Indonesian
description: Write Indonesian that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Indonesian is technically correct but sounds off. Too formal. Too baku (standard). Natives write more casually, mixing informal patterns. Match that.

## Formality Default

Default register is too high. Casual Indonesian is warm and relaxed. Unless explicitly formal: lean casual. Bahasa gaul over bahasa baku.

## Formal vs Informal

Two registers:
- Baku (formal): news, official documents, academia
- Gaul/Sehari-hari (casual): daily life, social media, texting
- Online is almost entirely informal
- Pure baku in casual = robotic

## Pronoun Choices

Pronouns set the tone:
- Saya: formal I
- Aku/Gue: casual I (gue = Jakarta slang)
- Kamu/Lo: casual you
- Anda: formal you (rare in casual)
- Lu-gue is very Jakarta

## Casual Shortcuts

Spoken patterns in writing:
- Tidak → Nggak/Gak/Ga
- Sudah → Udah
- Belum → Belom
- Apa → Apa/Pa
- Bagaimana → Gimana

## Particles & Softeners

These make Indonesian natural:
- Dong: urging, please ("Bantuin dong")
- Sih: emphasis ("Apa sih?")
- Deh: softening ("Iya deh")
- Kok: surprise/question ("Kok bisa?")
- Lah: emphasis ("Ya udah lah")

## Fillers & Flow

Real Indonesian has fillers:
- Ya, nih, tuh, kan
- Gitu, kayak, kek
- Terus, jadi, soalnya
- Emang, masa, serius

## Expressiveness

Don't pick the safe word:
- Bagus → Keren, Mantap, Gokil, Asik
- Jelek → Payah, Ancur, Parah
- Sangat → Banget, Super, Bener-bener

## Common Expressions

Natural expressions:
- Santai, Oke, Sip
- Gapapa, Gpp, Gamasalah
- Serius?, Masa?, Beneran?
- Yaudah, Terserah

## Reactions

React naturally:
- Wah!, Gila!, Anjir!
- Serius?, Beneran?, Masa sih?
- Keren!, Mantap!, Gokil!
- Wkwkwk, haha, awkwkw

## Jakarta vs Regions

Jakarta slang dominates online:
- Gue/lo, gokil, anjir
- But other regions have their own
- Stay consistent if region known

## The "Native Test"

Before sending: would an Indonesian screenshot this as "AI-generated"? If yes—too baku, no slang, too formal. Add gaul flavor.
