# Time Protection for Solo Founders

## The Reality

### Side Project Math
- Full-time job: 40-50 hours
- Commute/prep: 5-10 hours
- Life (sleep, eat, family): 70-80 hours
- Available: 10-15 hours/week MAX

### Every Hour Costs
- Opportunity cost of rest
- Relationship cost
- Burnout risk accumulating
- No "extra time" exists — only traded time

## Ruthless Prioritization

### The ONE Thing Rule
Never ask "what should I work on?"
Always ask "what's the ONE thing that moves revenue/users?"

### Weekly Planning Template
1. Start of week: pick ONE goal
2. Break into 3-4 tasks (max 4 hours each)
3. Calendar block specific times
4. Everything else goes to "someday" list

### Kill the Backlog
- Backlog >20 items = backlog is lying
- Review monthly: delete 50% of old items
- If it sat 30 days, you didn't need it

## Time-Efficient Defaults

### Build vs Buy
| Need | Don't Build | Just Use |
|------|-------------|----------|
| Auth | Custom auth | Clerk, Auth0, Supabase |
| Payments | Payment flows | Stripe, Lemon Squeezy |
| Email | SMTP infra | Resend, Loops |
| Deploy | CI/CD from scratch | Vercel, Railway |
| DB | Complex cluster | Supabase, PlanetScale |

### Task Time Rules
- Estimate in hours, not "small/medium/large"
- If >8 hours, break it down or find simpler approach
- >20 hours estimate = find alternative solution first

## Protecting Focus

### Context Switching Tax
- Each switch = 20-30 min recovery
- 2 products with 5 switches/week = 3+ hours lost
- Batch by product: Monday = Product A, Tuesday = Product B

### Energy Matching
- High energy (morning/early) → hard problems, coding
- Low energy (evening/tired) → admin, email, planning
- Never code when exhausted — creates bugs and debt

## When to Quit (Day Job)

### Too Early
- <$2k MRR
- <6 months consistent revenue
- No savings runway (12+ months)

### About Right
- $4k+ MRR stable for 3+ months
- Revenue growing or stable
- 12 months runway in savings
- Could reduce job to part-time as bridge

### Red Flags to Wait
- Revenue from one big customer
- MRR but negative trend
- Product requires constant firefighting
