# Pricing for Indie Hackers

## Core Principles

### Price Higher Than Comfortable
- Indie hackers underprice by 2-3x on average
- Fear of rejection != market data
- $29 product at 100 sales = $2900
- $97 product at 40 sales = $3880 (fewer support tickets too)

### Pricing Models by Type

| Product Type | Default Model | Why |
|--------------|---------------|-----|
| SaaS tool | Monthly subscription | Recurring = predictable |
| Template/boilerplate | One-time | Low maintenance |
| Course | One-time + cohort premium | Cohort = higher price |
| Community | Annual subscription | Reduces churn |

## How to Set Initial Price

### 1. Competitor Benchmark
- Find 3-5 direct competitors
- Note their pricing tiers
- You don't need to be cheapest — need clear differentiation

### 2. Value Calculation
- What does customer save/earn with your tool?
- Price at 10-20% of that value
- Example: Save 5 hours/month × $100/hour = $500 → charge $50-100

### 3. Segment Consideration
- Students/hobbyists: $9-29
- Freelancers/small biz: $29-99
- Businesses: $99-499
- Enterprise: $500+/custom

## Testing Prices

### Raise Until Conversion Drops
1. Start at confident price
2. Raise 20% every 2 weeks
3. Monitor conversion rate
4. Stop when conversion drops >30%

### Grandfathering
- Raise prices on NEW customers only
- Email existing: "Price increasing next month, you're locked in"
- Tests elasticity without losing loyal users

## Common Mistakes

- Comparing to big company prices (different game)
- Free tier too generous (devalues paid)
- Monthly AND annual at same effective rate (no annual incentive)
- Discounting to close deals (trains customers to wait)
- LTD (lifetime deals) = future revenue destroyed
