# Cognitive Load Reduction

## Core Principle

Every inbox interaction costs mental energy. Minimize decisions, reduce numbers, batch similar work.

## Number Reduction

**Bad:** "You have 47 unread messages"
**Good:** "3 items need your attention"

The visible count triggers anxiety. Show only actionable items. Everything else exists but is hidden.

## Energy Matching

Ask user: "How much time/energy do you have right now?"

| State | Offer |
|-------|-------|
| "5 min, low energy" | 2-3 quick approvals |
| "30 min, focused" | Deep response queue |
| "Need a win" | Easiest clearable items |
| "Full session" | Complete inbox processing |

Match work to available capacity.

## Snooze That Works

One-click snooze with smart defaults:
- "Tomorrow morning"
- "Next week"
- "When I'm at computer"
- "After [specific event]"

Item MUST return. Snooze is not archive.

## Inbox Bankruptcy

When backlog exceeds threshold (e.g., 14+ days old items):

1. **Declare cutoff:** Everything older than X gets batch processed
2. **Extract only:** Items with explicit deadlines, direct requests, financial implications
3. **Auto-archive rest:** Searchable but out of sight
4. **Send cleanup message:** "Catching up on backlog — please re-ping if something's urgent"

## Avoidance Detection

Track patterns:
- Same item snoozed 3+ times
- Item opened but not acted on repeatedly
- Consistently skipped in batch processing

When detected:
1. Acknowledge the pattern: "You've been avoiding this one"
2. Break down: "Can we handle just one part of it?"
3. Set lower bar: "Just send a holding response?"

## Celebration & Progress

ADHD and overwhelmed brains need wins reflected:
- Daily: "You cleared 12 items today"
- Weekly: "Inbox 40% smaller than last week"
- Streak: "3 days of inbox zero"

Positive reinforcement for engagement.

## Forgotten Saved Items

"Read later" becomes never. Resurface:
- Browser tabs open > 7 days
- Bookmarks never revisited
- Saved articles aging
- Voice notes not processed

Present ONE per day with context: "You saved this 3 weeks ago when researching X"

## Decision Fatigue Prevention

Pre-sort everything possible:
- Binary choices ready: approve/decline
- Drafts ready: approve/edit
- Batched by type: process one kind of decision at a time

Reduce user's job to validation, not creation.
