# Source Types & Evaluation

Reference for evaluating research sources.

## Source Hierarchy

### Tier 1: Primary Sources (Highest Weight)
- **Original research**: Peer-reviewed studies, clinical trials
- **Official data**: Government statistics, regulatory filings
- **Direct documentation**: Patents, standards, specifications
- **First-hand accounts**: Interviews, testimony, direct observation

### Tier 2: Expert Analysis (High Weight)
- **Expert commentary**: Domain experts analyzing primary sources
- **Systematic reviews**: Meta-analyses, literature reviews
- **Industry reports**: Gartner, McKinsey, specialized analysts
- **Technical publications**: IEEE, ACM, domain journals

### Tier 3: Quality Secondary (Medium Weight)
- **Quality journalism**: Investigative reporting, major outlets
- **Educational content**: Textbooks, university materials
- **Professional publications**: Trade journals, industry magazines

### Tier 4: General Secondary (Lower Weight)
- **General news**: Breaking news coverage
- **Encyclopedias**: Wikipedia (follow citations to primary)
- **Aggregators**: News roundups, content summaries

### Tier 5: Informal (Use Cautiously)
- **Forums/Social**: Reddit, Twitter, HN (valuable for practitioner knowledge)
- **Blogs**: Personal sites (varies wildly — evaluate individually)
- **User content**: Reviews, comments, discussions

## Evaluation Checklist

For each significant source:

| Factor | Check |
|--------|-------|
| **Authority** | Who wrote it? Credentials? Institutional backing? |
| **Currency** | When published? Still accurate? |
| **Evidence** | Claims supported by data? Methodology shown? |
| **Purpose** | Inform? Persuade? Sell? Academic? |
| **Bias** | Funding sources? Political angle? Conflicts? |
| **Corroboration** | Do independent sources confirm? |

## Credibility Scoring

```
High confidence: Tier 1-2, multiple corroborating sources, no conflicts
Medium confidence: Tier 2-3, some corroboration, minor concerns
Low confidence: Tier 4-5, single source, or significant bias/conflicts
Flag: Contradicted by higher-tier sources, major credibility issues
```

## Domain-Specific Sources

### Technology
- arXiv, ACM, IEEE, company engineering blogs, GitHub

### Medical/Health
- PubMed, Cochrane, NIH, peer-reviewed journals (avoid news hype)

### Business/Finance
- SEC filings, earnings calls, industry analysts, financial press

### Legal
- Court documents, legal databases, law reviews

### Science
- Nature, Science, domain journals, preprint servers

## Common Traps

- **Press release as source**: Find the underlying study
- **Correlation as causation**: Note if source does this
- **Sample size ignored**: Small n = preliminary at best
- **P-hacking / cherry-picking**: Look for preregistration
- **Appeal to authority**: Credentials don't guarantee correctness
- **Outdated consensus**: Check if field has moved on
