# Research Output Formats

Templates for delivering research results. Match format to audience and purpose.

## Executive Summary

For decision-makers with limited time.

```
🔬 RESEARCH: [Topic]

⚡ BOTTOM LINE
[1-2 sentences: the answer]

📊 CONFIDENCE: [High/Medium/Low]

KEY FINDINGS
• [Finding 1]
• [Finding 2]  
• [Finding 3]

⚠️ MAIN CAVEAT
[Single most important limitation]

🎯 RECOMMENDATION
[What to do with this information]
```

Length: 1 page max. No methodology details. Decision-focused.

## Standard Report

For most research requests.

```
🔬 DEEP RESEARCH: [Topic]

## Question
[Specific question being answered]

## Answer
[Direct answer — 2-3 sentences]

## Confidence: [Level]
[Why this confidence level]

## Key Findings
### [Theme 1]
[Findings with source attribution]

### [Theme 2]
[Findings with source attribution]

## Contradictions & Uncertainties
[Where sources disagreed, what remains unclear]

## Gaps
[What couldn't be determined]

## Sources
[Numbered list with brief credibility notes]

## Methodology Note
[What was searched, how evaluated]
```

Length: 2-5 pages. Balanced depth.

## Academic/Comprehensive

For critical decisions or when methodology matters.

```
# Research Report: [Topic]

## Abstract
[Full summary of question, method, findings, conclusion]

## Research Question
[Precise formulation]

## Methodology
### Search Strategy
[Databases searched, queries used, date ranges]

### Inclusion/Exclusion Criteria
[What sources were considered, what was excluded and why]

### Evaluation Framework
[How sources were assessed]

## Findings
### [Section by theme]
[Detailed findings with full citations]

## Analysis
### Synthesis
[How findings connect]

### Contradictions
[Detailed analysis of disagreements]

### Confidence Assessment
[Systematic evaluation of certainty]

## Limitations
[What this research cannot answer]

## Conclusion
[Final answer with appropriate caveats]

## References
[Full academic citations]

## Appendix
[Search logs, evaluation notes, raw data]
```

Length: 10+ pages. Full documentation.

## Working Document

For research that will continue or be built upon.

```
# [Topic] — Research Notes

**Status:** [In progress / Complete / Needs more]
**Last updated:** [date]
**Confidence:** [level]

## Current Answer
[Best answer so far]

## What We Know
- [Finding] — [source] — [confidence]
- [Finding] — [source] — [confidence]

## Open Questions
- [ ] [Question still unanswered]
- [ ] [Thing that needs verification]

## Sources Consulted
| Source | Key Finding | Credibility | Notes |
|--------|-------------|-------------|-------|

## Search Log
[Queries tried, what worked, what didn't]

## Next Steps
[What would improve this research]
```

Length: Variable. Living document.

## Quick Answer

For simple factual questions.

```
**Q:** [Question]
**A:** [Direct answer]

Source: [single best source]
Confidence: [level]
```

Length: 3-5 lines. Only when depth isn't needed.
