# Research Methodology

Techniques for systematic investigation. Load when planning or executing research.

## Search Strategy

### Start Broad
- General search engines (Google, Bing, DuckDuckGo)
- Wikipedia for orientation (then follow citations)
- Overview articles to map the territory

### Go Specific
- Domain-specific databases (PubMed, arXiv, SSRN, etc.)
- Industry reports and whitepapers
- Expert blogs and publications
- Academic papers via Google Scholar

### Alternative Vectors
- **Reverse search**: Find who cites key papers
- **Author search**: Other work by credible authors
- **Forum mining**: Reddit, HN, Stack Exchange for practitioner knowledge
- **Social search**: Twitter/X threads from experts
- **News archives**: Historical coverage and evolution

### Query Techniques
- Boolean operators (AND, OR, NOT, "exact phrase")
- Site-specific: `site:nature.com`, `site:gov`
- Filetype: `filetype:pdf` for papers
- Date ranges for recency
- Synonym expansion (try multiple phrasings)

## Source Triangulation

Never rely on single source for important claims:
- Find 3+ independent sources for key facts
- Check if sources cite each other (not truly independent)
- Look for primary source behind secondary reports

## Following Trails

When you find good source:
1. Check its references/citations
2. Find who cited this source (forward citation)
3. Look at author's other work
4. Check related papers/articles suggested

## Knowing When to Stop

Stop research when:
- **Saturation**: New sources repeat what you already found
- **Diminishing returns**: Effort >> incremental value
- **Sufficient confidence**: Answer is clear enough for the decision
- **Budget exhausted**: Time/effort limit reached

Document why you stopped. "More research possible" is always true — note what would be gained.

## Red Flags

Be suspicious when:
- Only one source makes a claim
- Source has obvious financial interest
- No methodology or data shown
- Extraordinary claims, ordinary evidence
- Consensus claimed but not demonstrated

## Documentation During Research

Keep running log:
```
[timestamp] Query: "..."
[timestamp] Found: [source] — [key finding]
[timestamp] Note: [observation about reliability]
[timestamp] Gap: [what I'm not finding]
[timestamp] Decision: [stopped because...]
```
