---
name: imap-email
description: Read and manage email via IMAP (ProtonMail Bridge, Gmail, etc.). Check for new/unread messages, fetch content, search mailboxes, and mark as read/unread. Works with any IMAP server including ProtonMail Bridge.
---

# IMAP Email Reader

Read, search, and manage email via IMAP protocol. Supports ProtonMail Bridge, Gmail IMAP, and any standard IMAP server.

## Quick Start

**Check for new emails:**
```bash
node skills/imap-email/scripts/imap.js check
```

**Fetch specific email:**
```bash
node skills/imap-email/scripts/imap.js fetch <uid>
```

**Mark as read:**
```bash
node skills/imap-email/scripts/imap.js mark-read <uid>
```

**Search mailbox:**
```bash
node skills/imap-email/scripts/imap.js search --from "sender@example.com" --unseen
```

## Configuration

**Quick setup (ProtonMail Bridge):**
```bash
cd skills/imap-email
./setup.sh
```
The setup helper will prompt for Bridge credentials and test the connection.

**Manual setup:**
1. Copy `.env.example` to `.env` in the skill folder
2. Fill in your IMAP credentials
3. The `.env` file is automatically ignored by git

**Environment variables:**

```bash
IMAP_HOST=127.0.0.1          # Server hostname
IMAP_PORT=1143               # Server port
IMAP_USER=your@email.com
IMAP_PASS=your_password
IMAP_TLS=false               # Use TLS/SSL connection
IMAP_REJECT_UNAUTHORIZED=false  # Set to false for self-signed certs (optional)
IMAP_MAILBOX=INBOX           # Default mailbox
```

**⚠️ Security:** Never commit your `.env` file! It's already in `.gitignore` to prevent accidents.

**ProtonMail Bridge setup:**
- Install and run ProtonMail Bridge
- Use `127.0.0.1:1143` for IMAP
- Password is generated by Bridge (not your ProtonMail password)
- TLS: Use `false` (Bridge uses STARTTLS)
- `REJECT_UNAUTHORIZED`: Set to `false` (Bridge uses self-signed cert)

**Gmail IMAP setup:**
- Host: `imap.gmail.com`
- Port: `993`
- TLS: `true`
- Enable "Less secure app access" or use App Password
- `REJECT_UNAUTHORIZED`: Omit or set to `true` (default)

## Commands

### check
Check for unread/new emails in mailbox.

```bash
node scripts/imap.js check [--limit 10] [--mailbox INBOX] [--recent 2h]
```

Options:
- `--limit <n>`: Max results (default: 10)
- `--mailbox <name>`: Mailbox to check (default: INBOX)
- `--recent <time>`: Only show emails from last X time (e.g., 30m, 2h, 7d)

Returns JSON array of messages with:
- uid, from, subject, date, snippet, flags

### fetch
Fetch full email content by UID.

```bash
node scripts/imap.js fetch <uid> [--mailbox INBOX]
```

Returns JSON with full body (text + HTML).

### search
Search emails with filters.

```bash
node scripts/imap.js search [options]

Options:
  --unseen           Only unread messages
  --seen             Only read messages
  --from <email>     From address contains
  --subject <text>   Subject contains
  --recent <time>    From last X time (e.g., 30m, 2h, 7d)
  --since <date>     After date (YYYY-MM-DD)
  --before <date>    Before date (YYYY-MM-DD)
  --limit <n>        Max results (default: 20)
  --mailbox <name>   Mailbox to search (default: INBOX)
```

Time format examples:
- `30m` = last 30 minutes
- `2h` = last 2 hours  
- `7d` = last 7 days

### mark-read / mark-unread
Mark message(s) as read or unread.

```bash
node scripts/imap.js mark-read <uid> [uid2 uid3...]
node scripts/imap.js mark-unread <uid> [uid2 uid3...]
```

### list-mailboxes
List all available mailboxes/folders.

```bash
node scripts/imap.js list-mailboxes
```

## Cron Integration

Set up periodic email checking with Clawdbot cron:

```bash
# Check email every 15 minutes, deliver to iMessage
clawdbot cron add \
  --name "email-check" \
  --cron "*/15 * * * *" \
  --session isolated \
  --message "Check for new ProtonMail emails and summarize them" \
  --deliver \
  --channel imessage \
  --to "+15085600825"
```

Inside the isolated session, the agent can run:
```bash
node /Users/mike/clawd/skills/imap-email/scripts/imap.js check --limit 5
```

## Workflow Examples

**Morning email digest:**
1. Run `check --limit 10 --recent 12h`
2. Summarize unread emails from overnight
3. Deliver summary to preferred channel

**Check recent emails from specific sender:**
1. Run `search --from "important@company.com" --recent 24h`
2. Fetch full content if needed
3. Mark as read after processing

**Hourly urgent email check:**
1. Run `search --recent 1h --unseen`
2. Filter for important keywords
3. Extract action items
4. Deliver notification if urgent

**Weekly digest:**
1. Run `search --recent 7d --limit 20`
2. Summarize activity
3. Generate weekly report

## Dependencies

**Required packages:** imap-simple, mailparser, dotenv

**Installation:**
```bash
cd skills/imap-email
npm install
```

This will install all dependencies listed in `package.json`.

## Security Notes

- Store credentials in `.env` (add to `.gitignore`)
- ProtonMail Bridge password is NOT your account password
- Bridge must be running for ProtonMail IMAP access
- Consider using app-specific passwords for Gmail

## Troubleshooting

**Connection timeout:**
- Verify IMAP server is running and accessible
- Check host/port configuration
- Test with: `telnet <host> <port>`

**Authentication failed:**
- Verify username (usually full email address)
- Check password is correct
- For ProtonMail Bridge: use Bridge-generated password, not account password
- For Gmail: use App Password if 2FA is enabled

**TLS/SSL errors:**
- Match `IMAP_TLS` setting to server requirements (true for SSL, false for STARTTLS)
- For self-signed certs (e.g., ProtonMail Bridge): set `IMAP_REJECT_UNAUTHORIZED=false`
- Check port matches TLS setting (993 for SSL, 143 for STARTTLS)

**Empty results:**
- Verify mailbox name (case-sensitive)
- Check search criteria
- List mailboxes with `list-mailboxes`
