# Telegram Announcement — ImaginePro AI Agent Skill

## English

🎨 **NEW: AI Agent Skill for Image Generation**

ImaginePro now has a **zero-dependency Python skill** that lets AI coding agents generate images programmatically!

**What's included:**
- 5 AI Models: Midjourney, Flux, Nano Banana, Lumi Girl, Video
- Image upscaling (2x–4x), background removal, prompt enhancement
- JSON output for easy agent parsing
- Works with Claude Code, OpenClaw, ClaWHub, Codex, and any agent that runs shell commands

**Quick example:**
```bash
export IMAGINEPRO_API_KEY="your-key"
python3 imaginepro_api.py wait --prompt "a cyberpunk cityscape" --model flux
```

📖 Docs: https://platform.imaginepro.ai/ai-agent-skill
🔑 Get API Key: https://platform.imaginepro.ai/dashboard/setup
💰 Pricing: https://platform.imaginepro.ai/pricing

---

## 中文

🎨 **全新发布：AI Agent 图片生成技能**

ImaginePro 推出 **零依赖 Python 技能**，让 AI 编程助手可以通过代码自动生成图片！

**核心功能：**
- 5 大 AI 模型：Midjourney、Flux、Nano Banana、Lumi Girl、视频生成
- 图片放大（2x–4x）、背景移除、提示词增强
- JSON 输出，方便 AI Agent 解析
- 支持 Claude Code、OpenClaw、ClaWHub、Codex 等所有可执行命令的 AI Agent

**快速示例：**
```bash
export IMAGINEPRO_API_KEY="your-key"
python3 imaginepro_api.py wait --prompt "赛博朋克城市日落" --model flux
```

📖 文档：https://platform.imaginepro.ai/ai-agent-skill
🔑 获取 API Key：https://platform.imaginepro.ai/dashboard/setup
💰 定价：https://platform.imaginepro.ai/pricing
