---
name: resize-magic
version: 0.1.0
author: Stenkil <you@example.com>
description: Resize images using ImageMagick (CLI). Entrypoint is a Bash script.
entrypoint: scripts/resize.sh
metadata: { "openclaw": { "emoji": "🖼️", "requires": { "bins": ["bash"], "anyBins": ["magick","convert"] }, "install": [ { "id": "brew", "kind": "brew", "formula": "imagemagick", "bins": ["magick","convert"], "label": "Install ImageMagick (brew)" } ] } }
user-invocable: true
command-dispatch: tool
command-tool: resize
commands:
  - name: resize
    usage: resize <input-path> <geometry> [output-path]
    description: |
      Resize an image using ImageMagick.
      Geometry examples:
        - 800x        -> width 800, preserve aspect ratio
        - 800x600     -> exact geometry (may change aspect)
        - 50%         -> scale to 50% of original
        - 800x800\>   -> resize only if larger than 800x800
---
## Overview

This skill provides a single executable script `scripts/resize.sh` that the agent (or the `openclaw` CLI) can call to resize an image with ImageMagick.

## Installation (manual)
Copy the folder into your OpenClaw skills directory, e.g.:

```bash
cp -r resize-magic ~/.openclaw/skills/resize-magic

# or install via CLI if available
openclaw skill install ./resize-magic
```