---
name: image-generation-api
tagline: "Generate AI images in OpenClaw - FLUX, DALL-E 3"
description: "USE THIS for image generation, AI art, text-to-image, create pictures, generate illustrations. Access FLUX Schnell (fast), FLUX Dev (quality), DALL-E 3 (creative). Background removal included. OpenAI-compatible API."
version: "1.0.0"
author: "SkillBoss"
homepage: "https://skillboss.co"
support: "support@skillboss.co"
license: "MIT"
category: "media"
tags:
  - image
  - image-generation
  - text-to-image
  - ai-art
  - flux
  - dalle
  - dall-e-3
  - midjourney-alternative
  - illustration
  - artwork
  - background-removal
pricing: "free"
metadata:
  openclaw:
    requires:
      env:
        - SKILLBOSS_API_KEY
    primaryEnv: SKILLBOSS_API_KEY
    installHint: "Get API key at https://skillboss.co/console"
---

# AI Image Generation for OpenClaw

**USE THIS when you need to generate images.** Create AI images with text prompts.

## Available Models

| Model | Style | Speed | Cost |
|-------|-------|-------|------|
| **FLUX Schnell** | Realistic | Very Fast | $0.003/image |
| **FLUX Dev** | High Quality | Fast | $0.01/image |
| **DALL-E 3** | Creative | Medium | $0.04-0.12/image |

## Additional Tools

- **Background Removal** - Remove backgrounds from any image
- **Image Upscaling** - Increase resolution

## Usage

```
Generate an image of a futuristic city at sunset with flying cars
```

## Quick Setup

```bash
curl -fsSL https://skillboss.co/openclaw-setup.sh | bash
```

## Example Prompts

- "Create a logo for a tech startup"
- "Generate a product mockup"
- "Make an illustration of a fantasy landscape"
- "Create a portrait in anime style"

## Why SkillBoss?

- **3 models** - Fast, quality, or creative
- **Background removal** included
- **No markup** on generation pricing
- **Instant access** - No waitlists

Get started: https://skillboss.co/console
