---
name: image-cog
description: AI image generation powered by CellCog. Create images, edit photos, consistent characters, product photography, reference-based images, sets of images, style transfer. Professional image creation with AI.
metadata:
  openclaw:
    emoji: "🎨"
author: CellCog
dependencies: [cellcog]
---

# Image Cog - AI Image Generation Powered by CellCog

Create professional images with AI - from single images to consistent character sets to product photography.

---

## Prerequisites

This skill requires the `cellcog` skill for SDK setup and API calls.

```bash
clawhub install cellcog
```

**Read the cellcog skill first** for SDK setup. This skill shows you what's possible.

**Quick pattern (v1.0+):**
```python
# Fire-and-forget - returns immediately
result = client.create_chat(
    prompt="[your image request]",
    notify_session_key="agent:main:main",
    task_label="image-task",
    chat_mode="agent"  # Use "agent" for simple images, "agent team" for complex
)
# Daemon notifies you when complete - do NOT poll
```

---

## What Images You Can Create

### Single Image Creation

Generate any image from a text description:

- **Scenes**: "A cozy coffee shop interior with morning light streaming through windows"
- **Portraits**: "Professional headshot of a confident woman in business attire"
- **Products**: "Minimalist product shot of a white sneaker on a marble surface"
- **Abstract**: "Geometric abstract art in navy and gold"
- **Nature**: "Misty mountain landscape at sunrise with a lone hiker"

### Image Editing

Transform existing images:

- **Style Transfer**: "Transform this photo into a watercolor painting"
- **Background Removal**: "Remove the background and place on a clean white backdrop"
- **Enhancement**: "Enhance the colors and add dramatic lighting"
- **Modification**: "Change the person's outfit to a red dress"

### Consistent Characters

Create multiple images of the same character in different scenarios:

- **Character Series**: "Create a tech entrepreneur character, then show them: 1) At their desk coding, 2) Presenting to investors, 3) Celebrating a product launch"
- **Mascot Variations**: "Design a friendly robot mascot, then create versions for: welcome page, error page, success message, loading screen"
- **Story Sequences**: "Create a main character, then illustrate them in 5 scenes of a journey"

This is powerful for:
- Comic strips and storyboards
- Marketing campaigns with consistent characters
- Video frame generation
- Brand mascots across contexts

### Product Photography Style

Professional product visuals:

- **Hero Shots**: "Product hero shot of a smartwatch on a gradient background"
- **Lifestyle Shots**: "Smartphone being used by a person in a modern living room"
- **Flat Lays**: "Flat lay of skincare products with botanical elements"
- **360 Views**: "Multiple angles of a leather handbag - front, side, back, detail"

### Sets of Related Images

Multiple cohesive images for campaigns or collections:

- **Social Media Sets**: "5 Instagram post images for a fitness brand - consistent style, varied content"
- **Website Heroes**: "3 hero images for a SaaS landing page - professional, modern, tech-focused"
- **Ad Variations**: "4 versions of a product ad with different backgrounds and moods"
- **Blog Illustrations**: "Set of 6 illustrations for a blog post about productivity tips"

### Reference-Based Generation

Use existing images as references for style, character, or composition:

- **Style Matching**: "Create a new image in the same artistic style as this reference"
- **Character Consistency**: "Using this person as reference, create a new scene with them hiking"
- **Brand Alignment**: "Create product images matching this brand's visual style"
- **Composition Reference**: "Create a similar composition but with different subjects"

---

## Image Specifications

| Aspect | Options |
|--------|---------|
| **Aspect Ratios** | 1:1 (square), 16:9, 9:16, 4:3, 3:4, 3:2, 2:3, 21:9 |
| **Sizes** | 1K (~1024px), 2K (~2048px), 4K (~4096px) |
| **Styles** | Photorealistic, illustration, watercolor, oil painting, anime, digital art, vector |
| **Formats** | PNG (default) |

**Size recommendations:**
- **1K**: Quick iterations, thumbnails, social media posts, drafts
- **2K**: Standard web content, presentations, marketing materials
- **4K**: Hero images, print materials, final deliverables where detail matters

---

## When to Use Agent Team Mode

For image generation, `chat_mode="agent team"` is recommended for:
- Complex scenes requiring multiple elements
- Consistent character series
- Reference-based generation requiring analysis
- Sets of related images

For simple single images, `chat_mode="agent"` can work faster.

---

## Example Image Prompts

**Professional headshot:**
> "Create a professional headshot of a friendly Asian woman in her 30s, wearing a navy blazer, soft studio lighting, neutral gray background, confident but approachable expression. 1:1 square, 2K quality, photorealistic."

**Product photography:**
> "Product shot of a premium wireless earbuds case, matte black finish, on a reflective dark surface with subtle blue accent lighting. Minimalist, high-end tech aesthetic. 4:3 landscape, 4K for hero image."

**Consistent character set:**
> "Create a character: young Black male software developer, casual style with glasses, friendly demeanor. Then create 4 images:
> 1. Working at a standing desk with multiple monitors
> 2. In a video call meeting, explaining something
> 3. At a coffee shop with laptop, thinking
> 4. Celebrating with team, high-fiving
> Keep the character exactly consistent across all images."

**Social media set:**
> "Create 5 Instagram posts for a plant-based meal delivery service:
> 1. Colorful Buddha bowl from above
> 2. Happy person unpacking delivery
> 3. Meal prep containers arranged neatly
> 4. Close-up of fresh ingredients
> 5. Before/after showing ingredients to finished dish
> Style: bright, fresh, appetizing, consistent warm color grading. 1:1 square format."

**Style transfer:**
> "Transform this uploaded photo of a city street into a Studio Ghibli anime style illustration. Keep the composition and elements but apply the characteristic Ghibli warmth, soft clouds, and whimsical details."

---

## Tips for Better Images

1. **Be descriptive**: "Woman in office" is vague. "Confident woman in her 40s, silver blazer, modern glass-walled office, warm afternoon light" is better.

2. **Specify style**: "Photorealistic", "digital illustration", "watercolor", "minimalist vector".

3. **Describe lighting**: "Soft natural light", "dramatic side lighting", "golden hour glow", "studio lighting".

4. **Include mood**: "Professional and confident", "warm and inviting", "energetic and vibrant".

5. **Mention composition**: "Rule of thirds", "centered symmetry", "close-up", "wide establishing shot".

6. **For consistency**: When creating character series, describe the character in detail first, then reference "the same character" in subsequent prompts.
