# IMA Voice AI — AI Music Generation 🎵

**Generate professional music from text in seconds**

Transform text descriptions into complete music tracks using Suno & DouBao AI models. Perfect for content creators, podcasters, video producers, game developers, and musicians.

[![ClawHub](https://img.shields.io/badge/ClawHub-Creative-blueviolet)](https://clawhub.ai)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE)
[![Version](https://img.shields.io/badge/version-1.0.0-blue.svg)](CHANGELOG_CLAWHUB.md)

---

## ✨ Features

🎹 **3 Production-Ready AI Models**
- **Suno sonic-v5** (25 pts) — Latest engine, most powerful and full-featured
- **DouBao BGM** (30 pts) — Background music specialist
- **DouBao Song** (30 pts) — Vocal song generator

⚡ **Fast Generation**
- 10-45 seconds per track
- Real-time progress tracking
- MP3 output, ready for use

🎨 **Rich Customization**
- 100+ style tags (lo-fi, cinematic, pop, rock, ambient...)
- Custom lyrics or AI-generated
- Vocal gender control (male/female/instrumental)
- Tempo control (BPM)
- Duration: 4-180 seconds

💎 **Professional Quality**
- High-quality MP3 audio
- Commercial-use ready
- Royalty-free output

---

## 🚀 Quick Start

### 1. Get API Key
Get your IMA API key at https://imastudio.com

### 2. Set Environment Variable
```bash
export IMA_API_KEY=ima_your_key_here
```

### 3. Generate Music
Just describe what you want in natural language:

**Examples:**
```
"Generate upbeat lo-fi hip hop, 90 BPM, no vocals"
→ Perfect study/work background music

"Epic orchestral cinematic, dramatic strings, 120 BPM, 60 seconds"
→ Movie trailer-style music

"Acoustic guitar, calm and peaceful, coffee shop ambiance"
→ Relaxing café background
```

---

## 🎯 Use Cases

| Use Case | Example |
|----------|---------|
| 🎬 **YouTube/TikTok** | Background music for videos |
| 🎙️ **Podcast** | Custom intro/outro music |
| 🎮 **Game Dev** | Dynamic soundtracks and loops |
| 📹 **Video Production** | Royalty-free commercial music |
| 🎸 **Musicians** | Quick demos and inspiration |
| 🏢 **Business** | Corporate presentations, brand themes |

---

## 🎹 Supported Models

| Model | Cost | Best For | Generation Time |
|-------|------|----------|----------------|
| **Suno sonic-v5** | 25 pts | Full-featured custom music, lyrics, vocals | 20-45s |
| **DouBao BGM** | 30 pts | Background music, ambient tracks | 10-25s |
| **DouBao Song** | 30 pts | Vocal songs, structured compositions | 10-25s |

---

## 📝 Prompt Examples

### Background Music
```
"upbeat lo-fi hip hop, 90 BPM, no vocals, chill vibes"
"calm ambient piano background"
"corporate presentation music, professional, uplifting"
```

### Cinematic
```
"epic orchestral cinematic, dramatic strings, 120 BPM"
"tense and dramatic horror soundtrack"
"fantasy adventure theme, medieval folk instruments"
```

### Retro/Nostalgic
```
"80s synthwave with retro drums, nostalgic, instrumental"
"90s hip-hop beat, boom bap style"
"vaporwave aesthetic, dreamy synths"
```

### Chill/Relaxing
```
"acoustic guitar, calm and peaceful, coffee shop ambiance"
"meditation music, soft piano, nature sounds"
"jazz lounge, smooth saxophone"
```

### Energetic
```
"upbeat pop, happy and energetic, female vocals"
"EDM drop, festival vibes, 128 BPM"
"rock anthem, electric guitar, powerful drums"
```

---

## 🔧 Advanced Features (Suno)

- **Custom Mode**: Write your own lyrics or let AI generate them
- **Instrumental Mode**: Pure instrumental tracks without vocals
- **Style Tags**: Choose from 100+ genre tags
- **Negative Tags**: Exclude unwanted styles (e.g., "no heavy metal")
- **Tempo Control**: Set specific BPM
- **Vocal Gender**: Male, female, or none
- **Duration**: 4-180 seconds

---

## 📖 Documentation

- **[SKILL.md](SKILL.md)** — Complete technical documentation
- **[INSTALL.md](INSTALL.md)** — Installation guide with dependencies
- **[SECURITY.md](SECURITY.md)** — Security policy and privacy details
- **[CHANGELOG_CLAWHUB.md](CHANGELOG_CLAWHUB.md)** — Version history and features
- **[CLAWHUB_PUBLISH_GUIDE.md](CLAWHUB_PUBLISH_GUIDE.md)** — Publishing guide

---

## 🔗 Related Skills

- **[ima-image-ai](https://clawhub.ai/skills/ima-image-ai)** — AI image generation (text-to-image, image-to-image)
- **[ima-video-ai](https://clawhub.ai/skills/ima-video-ai)** — AI video generation (text/image-to-video)
- **[ima-ai-creation](https://clawhub.ai/skills/ima-ai-creation)** — All-in-one image/video/music workflows

---

## 🔐 Security & Best Practices

✅ **Read-only skill** — No modifications allowed, ensures reliability  
✅ **API key required** — Set `IMA_API_KEY` environment variable  
✅ **Transparent file access** — Stores preferences in `~/.openclaw/memory/ima_prefs.json` and logs in `~/.openclaw/logs/`  
✅ **Auto-cleanup** — Logs auto-delete after 7 days  
✅ **User control** — Delete preferences/logs anytime without breaking the skill  
✅ **No personal data** — Only stores model preferences and timestamps  
✅ **Production-validated** — Tested on real IMA infrastructure  

**Full details:** See [SECURITY.md](SECURITY.md) for complete privacy policy and [INSTALL.md](INSTALL.md) for setup instructions.  

---

## 📊 Why Choose This Skill?

| Feature | This Skill | Others |
|---------|-----------|--------|
| **Latest Models** | ✅ Suno sonic-v5 (2026) | ❌ Outdated |
| **Generation Speed** | ✅ 10-45s | ❌ 60s+ |
| **Custom Lyrics** | ✅ Full support | ❌ Limited |
| **Style Options** | ✅ 100+ tags | ❌ <20 |
| **Cost Transparency** | ✅ Shown upfront | ❌ Hidden |
| **User Memory** | ✅ Remembers preferences | ❌ No memory |

---

## 📄 License

MIT License — See [LICENSE](LICENSE) for details.

---

## 🌟 Support

- **GitLab Issues**: [Report bugs or request features](https://git.joyme.sg/imagent/skills/ima-voice-ai/-/issues)
- **ClawHub Comments**: Leave feedback on the skill page
- **API Provider**: [IMA Studio](https://imastudio.com)

---

## 🎉 Get Started

1. Install the skill from [ClawHub](https://clawhub.ai/skills/ima-voice-ai)
2. Set your `IMA_API_KEY`
3. Start generating music!

**Happy creating! 🎵**
