# VI 设计 (Visual Identity)

> **核心**: 统一化视觉符号传递品牌理念的完整识别体系

---

## 1. VI 设计概述

### 定义
**VI (Visual Identity)** = 品牌视觉识别系统
- 核心: Logo + 标准色 + 专用字体
- 目标: 统一、独特的品牌形象
- 属于 CIS (企业识别系统) 的视觉识别部分

### 重要性
1. 统一品牌形象 (所有触点一致)
2. 提升辨识度 (Logo/颜色/字体记忆点)
3. 专业化形象 (系统化设计)
4. 降低传播成本 (规范化减少重复设计)
5. 跨媒介一致性 (线上线下统一)

---

## 2. VI 两大系统

```
VI 设计
  ├─ 基础系统 (Foundation) — 核心视觉元素
  │   ├─ Logo / 标准色 / 字体 / 辅助图形
  │
  └─ 应用系统 (Application) — 落地应用
      ├─ 办公用品 / 店面环境 / 包装产品
      ├─ 广告宣传 / 数字媒体 / 制服服装
```

---

## 3. 基础系统 (Foundation)

### 3.1 Logo 设计

**类型**:
- Logomark (纯图形): Apple 苹果、Twitter 小鸟
- Wordmark (文字): Google、Coca-Cola
- Combination (组合): Adidas、Starbucks

**核心规范**:
1. 标志墨稿 (黑白版)
2. 反白效果 (深色背景)
3. 标准化制图 (比例/尺寸)
4. 预留空间 (最小安全距离)
5. 最小尺寸限定 (如 16px)

**一致性要求** (最高级别):
⚠️ 禁止变形 / 禁止改色 / 禁止添加效果 / 不得小于最小尺寸

### 3.2 标准色彩

**色彩分层**:
- Primary (主色): 1-2 个 (品牌核心色)
- Secondary (辅助色): 2-3 个 (补充主色)
- Neutral (中性色): 2-3 个 (黑/白/灰)
- Functional (功能色): 成功/警告/错误

**色彩规范**: RGB / CMYK / HEX / Pantone 值

### 3.3 标准字体

**分类**:
- 中文字体: 思源黑体 / 方正兰亭黑 / 站酷高端黑
- 英文字体: Helvetica / Futura / Avenir / Montserrat
- 数字字体: DIN / Arial / Roboto

**字阶系统**: H1-H6 / Body / Caption (字号/行高/字重)

### 3.4 辅助图形

**类型**:
- 几何图案 (品牌元素延伸)
- 装饰图案 (增强视觉丰富度)
- 背景纹理 (辅助信息层次)

---

## 4. 应用系统 (Application)

### 分类

| 系统 | 典型应用 |
|------|---------|
| 办公用品 | 名片 / 信纸 / 信封 / 文件夹 / 工作证 |
| 店面环境 | 门头招牌 / 室内装潢 / 导视系统 / 收银台 |
| 包装产品 | 产品包装 / 手提袋 / 贴纸 / 标签 |
| 广告宣传 | 海报 / 易拉宝 / 户外广告 / 宣传册 |
| 数字媒体 | 网站 / App / 社交媒体 / 电子邮件 |
| 制服服装 | 员工制服 / T恤 / 围裙 / 帽子 |

---

## 5. Reference-Driven 工作流

### 核心方法论

```
Step 1: 基础系统 (Foundation) → 生成核心视觉元素
  ↓
Step 2: 应用系统 (Application) → 用基础元素生成应用物料
  ↓
Step 3: reference_strength 分层控制一致性
```

### 工作流程

**Phase 1: Logo 设计**
- 生成 Logo 正稿 (高分辨率，PNG 透明背景)
- 模型: Nano Banana Pro 4K / SeeDream 4.5
- 提示词: 完整描述 (形状/颜色/风格/寓意)

**Phase 2: 基础系统延伸**
- 用 Logo 作为参考
- 生成 Logo 变体 (黑白版/反白版/单色版)
- reference_strength: 0.95 (极高一致性)

**Phase 3: 应用物料生成**
- 用 Logo + 色彩规范作为参考
- 生成各类应用场景 (名片/海报/包装...)
- reference_strength: 0.80-0.90 (允许适配不同场景)

---

## 6. reference_strength 策略

| 应用场景 | 推荐值 | 说明 |
|---------|--------|------|
| Logo 变体 | 0.93-0.95 | 最高一致性 |
| 办公用品 | 0.88-0.92 | Logo 完整呈现 |
| 店面招牌 | 0.85-0.90 | 适应不同尺寸 |
| 包装产品 | 0.82-0.88 | 适应不同材质 |
| 广告海报 | 0.80-0.85 | 创意灵活性 |
| 数字媒体 | 0.78-0.85 | 响应式适配 |

**原则**: Logo 直接呈现 → 高 strength；创意延伸 → 中等 strength

---

## 7. 实战案例模板

### 咖啡店 VI 设计 "晨光咖啡"

**需求**: 小清新咖啡店，完整 VI 系统

**Phase 1: 基础系统**
- Logo: 咖啡杯+太阳图形组合 (Nano Banana Pro 4K)
- 主色: 暖橙色 #FF8C42 / 咖啡棕 #8B4513
- 字体: 思源黑体 + Montserrat
- 成本: 18 pts

**Phase 2: 办公用品 (6 项)**
- 名片 / 信纸 / 信封 / 优惠券 / 会员卡 / 工作证
- reference_strength: 0.90
- 成本: 6×18 = 108 pts

**Phase 3: 店面环境 (4 项)**
- 门头招牌 / 室内墙面 / 菜单板 / 收银台背景
- reference_strength: 0.88
- 成本: 4×18 = 72 pts

**Phase 4: 包装产品 (5 项)**
- 咖啡杯套 / 手提袋 / 糕点盒 / 贴纸 / 外卖包装
- reference_strength: 0.85
- 成本: 5×18 = 90 pts

**Phase 5: 广告宣传 (3 项)**
- 开业海报 / 优惠活动海报 / 户外广告牌
- reference_strength: 0.82
- 成本: 3×18 = 54 pts

**总成本**: 342 pts | **总时间**: 3-4 小时  
**交付物**: 1 Logo + 18 应用物料

---

## 8. 常见错误

### ❌ 错误 1: 跳过基础系统
**问题**: 直接生成应用物料，没有统一基础  
**后果**: 各物料风格不一致  
**解决**: 必须先确定 Logo + 色彩 + 字体

### ❌ 错误 2: Logo reference_strength 过低
**问题**: Logo 应用时一致性差 (变形/变色)  
**解决**: Logo 直接呈现用 0.90+，变体用 0.93+

### ❌ 错误 3: 忽略不同材质适配
**问题**: 所有物料用同一设计，不考虑材质差异  
**解决**: 纸质/金属/布料/屏幕显示分别优化

### ❌ 错误 4: 缺少黑白版/反白版
**问题**: 只有彩色 Logo，深色背景无法使用  
**解决**: 必须生成黑白版和反白版

---

## 9. Quick Reference

### 交付物清单

| 系统 | 数量 | reference_strength | 成本估算 |
|------|------|-------------------|---------|
| 基础系统 | 1 Logo + 变体 | 0.93-0.95 | 18-36 pts |
| 办公用品 | 5-8 | 0.88-0.92 | 90-144 pts |
| 店面环境 | 3-5 | 0.85-0.90 | 54-90 pts |
| 包装产品 | 4-6 | 0.82-0.88 | 72-108 pts |
| 广告宣传 | 3-5 | 0.80-0.85 | 54-90 pts |
| 数字媒体 | 2-4 | 0.78-0.85 | 36-72 pts |

**典型项目**: 1 基础系统 + 20 应用物料 = **350-500 pts**

### 核心原则

1. **Foundation First** — 必须先建立基础系统
2. **Logo 最高一致性** — reference_strength 0.90+
3. **分层控制** — 不同应用场景不同 strength
4. **黑白版/反白版必备** — 适应不同背景
5. **考虑材质差异** — 纸质/金属/布料/屏幕分别优化

---

**记住**: VI 设计 = Foundation + Application + 分层一致性控制 🏢
