# Model Selection — 模型选择指南

> **目标**: 根据任务类型和需求，选择最合适的模型

---

## 1. 任务类型汇总

> ⚠️ **任务类型选择是基础**：任务类型选错了，再怎么选模型都不对！

### 1.1 图像生成 (ima-image-ai)

| 任务类型 | 说明 | 示例 |
|---------|------|------|
| **text_to_image** | 文生图：根据文字描述生成全新图像 | "一只可爱的猫坐在窗台上" |
| **image_to_image** | 图生图：基于参考图修改/变换风格，或根据参考图生成新图片 | "改成水彩画风格" / "参考这张图生成类似的" |

---

### 1.2 视频生成 (ima-video-ai)

| 任务类型 | 说明 | 示例 |
|---------|------|------|
| **text_to_video** | 文生视频：根据文字描述生成全新视频 | "一个人在海边跑步" |
| **image_to_video** | 首帧生视频：提供的图片将作为视频首帧，生成后续动画 ⚠️ | 提供图片 + "让人物动起来" |
| **first_last_frame_to_video** | 首尾帧生视频：根据首帧和尾帧生成中间过渡动画 | 提供开始图和结束图 |
| **reference_image_to_video** | 参考图生视频：参考输入图片的视觉形象（风格/角色），但不固定为首帧 ⚠️ | 提供角色参考 + "这个角色在跳舞" |

**重要区别**:
- **image_to_video**: 输入图片 = 视频首帧（固定）
- **reference_image_to_video**: 输入图片 = 视觉参考（不固定首帧，只保持形象一致）

---

### 1.3 音乐生成 (ima-voice-ai)

| 任务类型 | 说明 | 示例 |
|---------|------|------|
| **text_to_music** | 文生音乐：根据描述生成背景音乐或歌曲 | "轻快的爵士乐" |

---

### 1.4 任务类型总结

**共 7 种任务类型**:

1. **图像** (2 种): text_to_image, image_to_image
2. **视频** (4 种): text_to_video, image_to_video, first_last_frame_to_video, reference_image_to_video
3. **音乐** (1 种): text_to_music

---

## 2. 模型选择策略

### 2.1 基础原则 (第一版)

> **简单有效**: 优先选择排行榜分数高、表现好的模型

**数据来源**: Arena.AI 模型排行榜 (https://arena.ai/leaderboard)  
**更新时间**: 2026-03-03

**选择逻辑**:
1. 确定任务类型 (text_to_image / text_to_video 等)
2. 查询该任务类型支持的模型列表
3. 选择排行榜分数最高的模型
4. 如果有用户偏好 → 使用用户偏好模型

---

### 2.2 图像生成模型排行 (text_to_image / image_to_image)

**IMA 可用模型排行** (基于 Arena.AI):

| 推荐顺序 | IMA 模型 | Arena 模型 | 评分 | 排名 | 成本 | 说明 |
|---------|---------|-----------|------|------|------|------|
| 🥇 **首选** | Nano Banana2 | gemini-3.1-flash-image-preview | 1280 | **#1** | 4 pts | **最高分** 🏆 |
| 🥈 **次选** | Nano Banana Pro | gemini-3-pro-image-preview | 1233 | #4 | 10-18 pts | 高质量 |
| 🥉 **经济** | SeeDream 4.5 | seedream-4.5 | 1145 | #15 | 5 pts | 性价比 |
| ⭐ **特殊** | Midjourney | - | N/A | - | 8-10 pts | 艺术美学强，文字渲染弱 ⚠️ |

**⚠️ OpenAI 模型内容策略警告**:
- OpenAI (DALL-E) 对真人形象有严格限制
- **涉及真人形象的任务**：不推荐选择 OpenAI 模型
- 限制包括：真人照片、名人肖像、照片风格化等
- 建议优先选择 Google (Nano Banana) 或 ByteDance (SeeDream) 模型

**Midjourney 使用场景** ⚠️:
- ✅ **适合**: 艺术创作、海报设计、概念图、风格化图像
- ❌ **不适合**: 需要文字渲染的场景（Logo、海报文字、标题等）
- **原因**: 美学和艺术感出色，但文字渲染能力较差

**默认推荐** (修正后):
- **最高质量** → **Nano Banana2** (1280分, 排名#1) 🏆 ← **纠正：原错误推荐Pro**
- **性价比** → **SeeDream 4.5** (5 pts, 1145分, #15)
- **预算充足** → **Nano Banana Pro** (10-18 pts, 1233分, #4)
- **艺术创作** → **Midjourney** (美学强，避免文字内容) ⚠️

---

### 2.3 视频生成模型排行 (text_to_video)

**IMA 可用模型排行** (基于 Arena.AI):

| 推荐顺序 | IMA 模型 | Arena 评分 | 排名 | 成本 | 说明 |
|---------|---------|-----------|------|------|------|
| 🥇 **顶级** | Google Veo 3.1 | 1371 | #3 | 高 | 最高分 |
| 🥇 **顶级** | Sora 2 Pro | 1368 | #4 | 高 | OpenAI 旗舰 |
| 🥈 **性价比** | Wan 2.6 | 1343 | #8 | 25 pts | 平衡选择 ⭐ |
| 🥉 **良好** | SeeDance 1.5 Pro | 1255 | #13 | 中 | Bytedance |
| - | Kling 2.6 Pro | 1219 | #16 | 中 | KlingAI |
| - | Kling O1 Pro | 1208 | #18 | 48-120 pts | 可变成本 |
| - | Hailuo 2.3 | 1200 | #20 | 38 pts | MiniMax |

**默认推荐** (第一版):
- **追求最高质量** → **Sora 2 Pro** (分数 1368) 或 **Veo 3.1** (分数 1371)
- **平衡质量和成本** → **Wan 2.6** (分数 1343, 25 pts) ⭐ **首选**
- **经济实惠** → **Hailuo 2.3** (分数 1200, 38 pts)

---

### 2.4 音乐生成 (text_to_music)

**当前策略**: Arena.AI 暂无音乐排行榜，使用默认推荐

| 模型 | 成本 | 说明 |
|------|------|------|
| **Suno sonic-v5** | 25 pts | 默认首选，功能最全 |
| DouBao BGM | 30 pts | 背景音乐 |
| DouBao Song | 30 pts | 歌曲生成 |

**默认推荐**: **Suno sonic-v5** (最新引擎，支持自定义模式)

---

## 3. Quick Reference

### 模型推荐速查

#### 图像生成 (text_to_image / image_to_image)

| 场景 | 推荐模型 | 原因 |
|------|---------|------|
| **追求最高质量** 🏆 | **Nano Banana2** | **Arena 评分 1280, #1 (冠军)** |
| 预算充足 | Nano Banana Pro | 10-18 pts, 评分 1233, #4 |
| 性价比 | SeeDream 4.5 | 5 pts, 评分 1145, #15 |

#### 视频生成 (text_to_video)

| 场景 | 推荐模型 | 原因 |
|------|---------|------|
| 追求最高质量 | Sora 2 Pro / Veo 3.1 | Arena 评分 1368/1371, #3/#4 |
| **性价比首选** ⭐ | **Wan 2.6** | **25 pts, 评分 1343, #8** |
| 经济实惠 | Hailuo 2.3 | 38 pts, 评分 1200 |

---

### 任务类型快速判断

| 用户需求 | 任务类型 |
|---------|---------|
| 只有文字描述 → 生成图像 | text_to_image |
| 提供参考图 → 修改/参考生成图像 | image_to_image |
| 只有文字描述 → 生成视频 | text_to_video |
| 提供图片 → 作为首帧生成视频 | image_to_video |
| 提供首尾两张图 → 生成过渡 | first_last_frame_to_video |
| 提供参考图 → 保持形象生成视频 | reference_image_to_video |
| 文字描述 → 生成音乐/BGM | text_to_music |

### 关键区别

| 对比 | image_to_video | reference_image_to_video |
|------|----------------|-------------------------|
| 输入图片用途 | **固定为首帧** | **仅作视觉参考** |
| 视频首帧 | 就是输入图片 | 不一定是输入图片 |
| 适用场景 | 让静态图动起来 | 用特定形象生成新动作 |

### 模型选择检查清单

- [ ] 任务类型已确定
- [ ] 查询该类型支持的模型
- [ ] 检查用户偏好 (ima_prefs.json)
- [ ] 如无偏好 → 选择排行榜最高分模型
- [ ] 如有偏好 → 使用用户偏好模型

---

**记住**: 任务类型选择正确 = 成功的第一步 🎯

---

## 4. 附录

### 4.1 内容策略与限制 ⚠️

**重要提示**: 所有AI图像生成服务都有内容策略限制，特别是涉及**真人形象、名人肖像、儿童形象**的场景。

**快速参考**:

| 服务商 | 真人照片上传 | 名人形象 | 儿童形象 | 风格化转换 |
|--------|-------------|---------|---------|-----------|
| **Google Imagen** | ⚠️ 可配置 | ❌ 禁止 | ❌ 严禁 | ⚠️ 限制 |
| **OpenAI DALL-E** | ❌ 禁止 | ❌ 禁止 | ❌ 严禁 | ❌ 禁止 (2025.8+) |
| **Midjourney** | ⚠️ 部分限制 | ⚠️ 部分禁止 | ❌ 严禁 | ⚠️ 限制 |
| **ByteDance** | ❌ 禁止 (2026.2+) | ⚠️ 限制 | ❌ 严禁 | ❌ 禁止 (真人) |

**图例**: ❌ 严格禁止 | ⚠️ 有限制/可配置 | ✅ 允许

**安全建议**:
- ✅ **虚构角色设计** — 完全合规，所有服务商支持
- ⚠️ **人物肖像** — 避免可识别的真实人物
- ❌ **名人/公众人物** — 绝对避免
- ❌ **儿童形象** — 绝对避免

**OpenAI 特别警告** ⚠️:
- OpenAI (DALL-E) 自 2025年8月起禁止所有真人照片风格化
- 包括：真人照片 → Pixar风格、吉卜力风格、油画等
- **涉及真人形象的任务应优先选择其他服务商**

---

_Current version: 2026-03-03 16:53 — Added OpenAI real-person policy warning_
