# 长视频制作工作流

> **核心挑战**: 模型最长 10-15s，如何制作 30s+长视频？

---

## 1. 模型限制

| 模型 | 最长时长 |
|------|---------|
| Wan 2.6 | 5-15s |
| Kling O1 | 5-10s |
| Veo 3.1 | 4-8s |
| Sora 2 Pro | 20s (高成本) |

**现实差距**: 用户需要 30s-3min 视频，技术只能生成 10-15s

---

## 2. 解决方案选择

### 决策树

```
视频时长？
  ├─ ≤15s → 镜头数？
  │   ├─ 1-4 个 → 多镜头切换 ✅
  │   └─ 5+ 个 → 分镜拼接
  └─ >15s → 分镜拼接 ✅
```

### 方案对比

| 维度 | 多镜头切换 | 分镜拼接 |
|------|-----------|---------|
| 时长 | ≤15s | 无限制 |
| 镜头数 | 2-4 个 | 无限制 |
| API 调用 | 1 次 | N 次 |
| 时间 | 1-2 分钟 | 10-60 分钟 |
| 精确控制 | 低 | 高 |
| 成本 | 25-50 pts | N×25-50 pts |
| 难度 | 简单 | 中等 |

---

## 3. 多镜头切换 (≤15s, 2-4 镜头)

### 提示词结构

```
Shot 1: [场景] + [运镜]
Cut to:
Shot 2: [场景] + [运镜]
Transition to:
Shot 3: [场景] + [运镜]
```

### 关键词

**切换**: `Cut to` / `Transition to` / `Fade to`  
**镜头**: `Close-up` / `Wide shot` / `Medium shot`  
**运镜**: `Camera zooms in` / `pans` / `rotates`

### 示例

**产品展示 (12s, 3 镜头)**:
- Shot 1: 产品特写，旋转镜头 (4s)
- Cut to: 使用场景，动态运动 (5s)
- Transition to: 包装展示，360°旋转 (3s)

**简单故事 (10s, 2 镜头)**:
- Opening: 女孩悲伤看手机，下午光线 (5s)
- Cut to close-up: 收到消息微笑，推镜头 (5s)

### 最佳实践

✅ **DO**: 明确标注镜头、使用切换词、2-4 个镜头、简洁描述  
❌ **DON'T**: 超过 4 镜头、缺切换词、过长描述、混合风格

---

## 4. 分镜拼接 (>15s, 5+ 镜头)

### 工作流

```
1. 分镜设计 → 分镜表 (每镜 4-10s)
2. 生成资产 → 参考图 (人物/场景/道具)
3. 逐镜生成 → reference_image_to_video
4. 剪辑拼接 → ffmpeg / 剪辑软件
```

### 分镜表模板

| 镜头 | 时长 | 场景/动作 | 镜头类型 | 关键元素 |
|------|------|-----------|---------|---------|
| 1 | 5s | 主角登场 | 全景 | 环境建立 |
| 2 | 4s | 表情特写 | 特写 | 情绪 |
| 3 | 6s | 动作场景 | 中景 | 叙事 |
| 4 | 5s | 结局/CTA | 特写 | Logo |

### 视觉资产生成

**目的**: 保持视觉一致性 (人物、场景、道具)

**资产类型**:
- 人物: 主角、配角的标准形象
- 场景: 主要场景的参考图
- 道具: 重要道具的标准样式

**用法**: 用 `reference_image_to_video` 模式，传入参考图 + `reference_strength`

### 一致性控制

| 元素 | reference_strength |
|------|-------------------|
| 人物面部 | 0.90-0.95 |
| 场景/道具 | 0.85-0.90 |
| 服装 | 0.75-0.85 |
| 风格 | 0.70-0.80 |

### 拼接方法

**基础拼接** (ffmpeg):
```bash
# 创建文件列表
cat > list.txt << EOF
file 'shot1.mp4'
file 'shot2.mp4'
file 'shot3.mp4'
EOF

# 无缝拼接
ffmpeg -f concat -safe 0 -i list.txt -c copy output.mp4
```

**进阶**: 添加转场 (0.5s 淡入淡出)、背景音乐、字幕/Logo

---

## 5. 实战案例

### 30s 产品广告 (6 镜头)

**方案**: 分镜拼接  
**流程**: 设计 6 镜头 (各 5s) → 生成产品参考图 (3 角度) + 场景参考 (2 个) → 逐镜生成 (6 次 API) → 剪辑 + 配乐 + Logo  
**成本**: ~180 pts | **时间**: 30-45 分钟

### 10s 社交短视频 (3 镜头)

**方案**: 多镜头切换  
**流程**: 写提示词 (Shot 1/2/3) → 生成 (1 次 API) → 可选添加字幕  
**成本**: ~25 pts | **时间**: 2-5 分钟

---

## 6. 常见错误

### ❌ 错误 1: 忽略视觉一致性
**问题**: 长视频中人物/场景每镜都不同  
**解决**: 使用参考图 + reference_strength 0.90+

### ❌ 错误 2: 单镜时长不当
**问题**: 镜头 2s (太短) 或 20s (超限制)  
**解决**: 控制每镜 **4-10s** (模型甜区)

### ❌ 错误 3: 误用多镜头切换
**问题**: 用多镜头切换做 30s 视频  
**解决**: 时长 >15s 必须用分镜拼接

---

## 7. Quick Reference

### 快速决策

| 条件 | 方案 |
|------|------|
| ≤15s, ≤4 镜头 | 多镜头切换 |
| >15s | 分镜拼接 |
| >4 镜头 | 分镜拼接 |
| 精确控制 | 分镜拼接 |
| 文字/Logo | 分镜拼接 |

### 核心原则

1. **时长 ≤15s** → 优先多镜头切换 (简单快速)
2. **时长 >15s** → 必须分镜拼接 (精确控制)
3. **视觉一致性** → 参考图 + reference_strength 分层
4. **单镜甜区** → 4-10s (模型最佳区间)
5. **提前规划** → 分镜表 → 资产 → 逐镜执行

---

**记住**: 长视频 = 精心设计的工作流，不是一次生成 🎬
