# 影视复古艺术系列最佳实践

**分类**: 艺术摄影/概念创作  
**推荐模型**: Midjourney (首选) / SeeDream 4.5 (备选) / Nano Banana Pro (预算)  
**贡献者**: 李鹤

---

## 核心视觉特征

| 特征 | 说明 |
|------|------|
| cinematic atmosphere with narrative storytelling | 电影氛围+叙事感 |
| vintage aesthetic fused with modern surrealism | 复古美学+现代超现实 |
| high-contrast dramatic lighting | 高对比度戏剧光影 |
| dreamlike and poetic mood | 梦幻诗意氛围 |
| editorial fashion quality | 时尚大片质感 |
| textured surfaces | 纹理表面（颗粒/天鹅绒/巴洛克细节） |
| bold color accents | 大胆色彩（霓虹/彩虹/深红） |

---

## 提示词模板

```
{subject_description},
cinematic composition, vintage-style aesthetic,
high-contrast dramatic lighting, dreamlike surreal atmosphere,
editorial fashion photography quality,
rich textures (analog grain, velvet, baroque details),
{color_accent: bold neon/rainbow/deep red tones},
narrative storytelling feel, whimsical and poetic mood,
shallow depth of field, atmospheric haze or smoke,
shot on high-end camera (Hasselblad/cinematic), 
pop surrealism meets classical painting,
detailed fabric and surface textures
```

---

## 参数建议

| 参数 | 建议值 |
|------|--------|
| aspect_ratio | 16:9 (电影感) |
| style_weight | high (强化艺术风格) |
| quality | premium (高质量输出) |

---

## 使用场景

- 概念艺术创作
- 高端时尚大片
- 音乐MV视觉
- 超现实人像
- 叙事性场景设计
- 复古电影风格海报

---

## 关键元素组合

**光影**: dramatic neon/rainbow/velvet background with atmospheric smoke

**造型**: baroque fashion + modern surreal elements

**镜头**: cinematic handheld or Hasselblad editorial style

**情绪**: dreamlike, whimsical, confident yet mysterious

**质感**: analog grain + rich fabric details + high contrast

---

## 示例变体

### 1. 宇宙超现实 (cosmic_surreal)

**重点**: rainbow/galaxy elements emerging from subject

**关键词**: cosmic thoughts, celestial background, pop surrealism

```
A woman with cosmic thoughts, rainbow/galaxy elements emerging from 
her head, cinematic composition, vintage-style aesthetic, high-contrast 
dramatic lighting, dreamlike surreal atmosphere, editorial fashion 
photography quality, rich textures (analog grain, velvet, baroque details), 
bold rainbow tones, narrative storytelling feel, whimsical and poetic mood, 
celestial background, pop surrealism meets classical painting, 16:9, 
Midjourney
```

---

### 2. 霓虹电影 (neon_cinematic)

**重点**: intense neon lighting with narrative scene

**关键词**: magenta glow, smoke-filled, music video atmosphere

```
A musician performing in abandoned theater, cinematic composition, 
vintage-style aesthetic, high-contrast dramatic lighting with intense 
magenta glow, dreamlike surreal atmosphere, editorial fashion photography 
quality, smoke-filled environment, rich textures (analog grain, velvet), 
bold neon tones, narrative storytelling feel, music video atmosphere, 
shot on cinematic handheld camera, 16:9, Midjourney
```

---

### 3. 巴洛克时尚 (baroque_editorial)

**重点**: classical painting meets high fashion

**关键词**: Rubens-style, velvet textures, full-length portrait

```
A model in baroque fashion outfit, cinematic composition, vintage-style 
aesthetic, high-contrast dramatic lighting, Rubens-style classical painting 
meets high fashion, editorial fashion photography quality, rich textures 
(velvet, baroque details, ornate fabric), deep red tones, narrative 
storytelling feel, full-length portrait, shot on Hasselblad, detailed 
fabric and surface textures, 16:9, Midjourney
```

---

## 调用示例

- "用影视复古艺术风格生成：一位都市女性站在雨夜霓虹街头"
- "影视复古风格：古典宫廷服饰模特，但背景是未来主义空间"
- "用这个风格：音乐家在废弃剧院演奏，光束从天窗照下"

---

## 负面词推荐

```
flat lighting, modern minimalist, plain background, 
low quality, blurry details, oversaturated colors,
generic stock photo, lifeless composition
```

---

## 质量优化技巧

**重点关注**:
- 高对比度光影 (high-contrast dramatic lighting)
- 纹理质感 (rich textures: analog grain, velvet, baroque details)
- 叙事性构图 (narrative storytelling feel, cinematic composition)
- 色彩对比 (bold color accents: neon/rainbow/deep red)

**常见问题**:
- ❌ 光影平淡 → 强调 "high-contrast dramatic lighting"
- ❌ 质感不足 → 添加 "rich textures (analog grain, velvet, baroque details)"
- ❌ 缺乏叙事感 → 强调 "narrative storytelling feel, cinematic atmosphere"
- ❌ 色彩单调 → 添加 "bold color accents (neon/rainbow/deep red tones)"

---

## 核心精髓

**复古与现代的碰撞** + **电影叙事感** + **艺术化质感**

**提炼来源**:
- 超现实宇宙拼贴（rainbow beam, galaxy, pop surrealism）
- 霓虹电影叙事（neon lighting, cinematic handheld, music video）
- 古典时尚肖像（Hasselblad, Rubens-style, baroque fashion）

---

_From: best-practices/cinematic-art.md_
