# Best Practices Index — 最佳实践索引

> **贡献者**: 李鹤  
> **更新时间**: 2026-03-03  
> **使用说明**: 根据任务场景选择对应文件，**按需读取**，避免占用过多上下文

---

## 📚 场景索引

| 场景 | 文件 | 适用任务 | 推荐模型 |
|------|------|---------|---------|
| 💎 **珠宝首饰** | [jewelry.md](jewelry.md) | 戒指、项链、手镯、耳环 | Midjourney / Nano Banana Pro |
| 💄 **护肤美妆** | [skincare.md](skincare.md) | 面霜、精华、乳液、化妆品 | Midjourney / SeeDream 4.5 |
| 🌸 **香水香氛** | [perfume.md](perfume.md) | 香水、香氛、空气清新剂 | Midjourney (图) / Wan 2.6 (视频) |
| 🎬 **影视艺术** | [cinematic-art.md](cinematic-art.md) | 概念艺术、时尚大片、MV视觉 | Midjourney / SeeDream 4.5 |

---

## 🎯 使用流程

### 对于 Agent

1. **识别任务类型** — 分析用户需求关键词
2. **查询索引表** — 匹配对应场景
3. **读取单个文件** — 只加载相关场景的详细模板
4. **应用模板** — 根据具体需求替换可变元素

**示例**:
```
用户: "帮我生成一张钻戒广告图"
→ 识别: 珠宝首饰
→ 读取: references/best-practices/jewelry.md
→ 应用: 钻戒模板 + 用户具体要求
```

---

## 🔍 快速匹配关键词

### 珠宝首饰 ([jewelry.md](jewelry.md))
- 戒指、钻戒、婚戒
- 项链、吊坠
- 手镯、手链
- 耳环、耳钉
- 黄金、铂金、钻石

### 护肤美妆 ([skincare.md](skincare.md))
- 面霜、乳液、精华
- 化妆品、粉底、口红
- 护肤品广告
- 美妆产品展示

### 香水香氛 ([perfume.md](perfume.md))
- 香水、香氛
- 空气清新剂
- 氛围感广告
- 电影质感展示

### 影视艺术 ([cinematic-art.md](cinematic-art.md))
- 概念艺术、艺术摄影
- 时尚大片、时尚摄影
- 音乐MV、视频视觉
- 超现实风格、复古风格
- 叙事性场景

---

## 💡 设计原则

**为什么拆分？**
1. ✅ **按需加载** — Agent 只读取需要的场景，减少 token 消耗
2. ✅ **快速定位** — 索引文件轻量，快速匹配场景
3. ✅ **易于维护** — 每个场景独立，更新不影响其他场景
4. ✅ **可扩展** — 新增场景只需添加新文件和索引条目

**何时读取索引？**
- 不确定场景时快速查询
- 需要概览所有可用模板时

**何时读取场景文件？**
- 已明确任务场景
- 需要完整提示词模板和示例

---

## 📊 Token 节省对比

| 场景 | 旧方案（单文件） | 新方案（拆分） | 节省 |
|------|----------------|--------------|------|
| 索引查询 | 13.3 KB (全读) | ~2 KB (索引) | **-85%** |
| 单场景应用 | 13.3 KB (全读) | ~3-4 KB (单文件) | **-70%** |

---

_Current version: 2026-03-03 17:19 — 拆分为按需加载结构_
