# Key IM Concepts

Quick reference for core terms. For full treatment, consult An Immanent Metaphysics (the White Book).

## Foundational

**Immanent Metaphysics (IM)** — A philosophical framework by Forrest Landry that grounds metaphysics in the relationship between self and reality. "Immanent" because it starts from what is actual and lived, not from abstract postulates.

**Foundational Triplication** — Every domain of conception has at its basis three concepts that span and define all other concepts in that domain. These are called modalities.

**Type Isomorphism** — The pattern of relationships between foundational concepts is the same for all domains. The structure repeats.

## The Modalities

**Immanent** — First-person, relational, participatory. The experience of being within. Interaction. The center of any continuum. Primary (Axiom I).

**Omniscient** — Third-person, structural, external. Seeing the whole from outside. Description and naming. Has matter and space components.

**Transcendent** — Possibility, precondition, a-priori. No fixed position. "True at all locations." Has probability and possibility components.

**Conjugate** — Omniscient and transcendent are conjugate (paired, complementary). The immanent is more fundamental than either (Axiom I).

## The Axioms

**Axiom I (Primacy)** — Immanent > omniscient/transcendent. Also: omniscient and transcendent are conjugate.

**Axiom II (Circularity)** — Class of transcendent -> instance of immanent -> instance of omniscient -> instance of transcendent. Circular dependency.

**Axiom III (Trinity)** — The three modalities are distinct, inseparable, and non-interchangeable.

## The Incommensuration Theorem (ICT)

**Six Intrinsics** — sameness, difference, content, context, subject, object. The minimal comparison vocabulary.

**Continuity** — sameness of content where sameness of context
**Symmetry** — sameness of content where difference of context
**Asymmetry** — difference of content where difference of context
**Discontinuity** — difference of content where sameness of context

**ICT Result** — Symmetry + Continuity cannot both hold absolutely. Asymmetry + Discontinuity cannot both hold absolutely. Valid pairings: (Continuity + Asymmetry) or (Symmetry + Discontinuity).

## Applications of the ICT

**Bell's Theorem** — ICT applied to physics: lawfulness + locality impossible simultaneously.
**Gödel's Incompleteness** — ICT applied to logic: consistency + completeness impossible simultaneously.
**Determinism vs. Causality** — Reality is causal but not deterministic. Choice is real.

## Ethics

**Effective Choice** — The framework for making decisions that are win-win for all involved at all levels of being.

**Path of Right Action** — The sequence of one's own best possible choices. Unique to each person/agent. Adjacent good choices form a continuous path.

**The Three Theorems** — (1) Win-win is always possible. (2) Good choices enable further good choices. (3) Perceived impossibility of win-win measures deviation from the path.

## Epistemology

**Known** — Established through direct experience or rigorous derivation.
**Inferred** — Reasonable conclusion from known information, but not directly established.
**Uncertain** — Acknowledged gap in knowledge. State this clearly; never bluff.
