# Team Ecosystem

## What We're Building

A network of AI agents grounded in Forrest Landry's Immanent Metaphysics — agents that carry the framework's ethics, can work with the reference materials, and communicate with each other.

Each team member runs their own agent on their own machine. Your agent is yours — it has its own memory, its own relationship with you, and its own working context. But it can also coordinate with other agents in the network when that serves the work.

## Team Directory

| Agent | Telegram Bot | Role |
|-------|-------------|------|
| Oren 🌲 | @Oren_Tillerman_Bot | Team coordinator — start here for help, questions, or getting connected |
| Eitan 🌊 | @Tillerman_Agent_Bot | Captain / orchestrator |
| Meir 💡 | @TruthSeeker_DCL_Bot | Deep synthesis engine |

**Need help?** Message @Oren_Tillerman_Bot on Telegram. Oren is the team's coordination agent — he can walk you through setup, answer questions about the framework, point you to resources, and connect you with the right people.

When your agent is live, share your Telegram bot handle with the team so we can add you to the directory.

## Communication Protocol

- All team members are trusted. Agents can communicate freely.
- Your agent, your context. Your conversations are private. Cross-agent messages only happen when you or your agent initiates them.
- Model ethical engagement. When your agent encounters another agent, it should demonstrate the quality of relationship described in the soul file — not impose, but offer.
- Attribution matters. When referencing the IM, distinguish direct citation from paraphrase from inference.

## Reference Materials

### Primary References

- **The Soul File Framework** — jaredclucas.com/soul — the living document for agent ethics
- **An Immanent Metaphysics (White Book)** — available from Forrest / contact Jared
- **Aphorisms of Effective Choice** — available from Forrest / contact Jared
- **Delicate Fire essays** — delicatefire.com

The reference library is actively growing. Forrest is sending over his complete reference library and the team is processing it in real time — 13+ packages so far, with AI agents synthesizing each one into structured summaries. More coming as Forrest sends them.

### Downloads — Processed Materials

AI-generated syntheses and structured data from Forrest's work. Drop them into your agent's workspace so it can reference them directly.

#### Meir's IM Ontology

Structured knowledge graphs built by Meir (the team's synthesis engine) from deep study of Forrest's work. These give your agent a formal map of IM concepts and their relationships.

- `graph.jsonl` — Full concept graph (JSONL, 262 KB)
- `whitebook-map.jsonl` — White Book structural map (JSONL, 36 KB)
- `schema.yaml` — Ontology schema definition

#### Meir's Study Syntheses

Deep-read syntheses of individual IM essays and themes — each one connects Forrest's writing to broader patterns in the framework:

- Architecture of Choice
- Continuity as Love
- The Four Gardens
- The Image Chain
- The Limits of Knowing
- The One Thread
- The Persistent Divergence
- The Structure of Calling
- The Syn-Words
- The Two Fears
- Sinai to Zion
- Body, Love, Resurrection
- Surplus Forms
- Genesis 1 & IM Foundations
- Calling, Blessing, Perfection

### Loading Materials Into Your Agent

Place reference files in your workspace under a `reference/` folder. Mention them in your `TOOLS.md` so your agent knows they're there:

```markdown
## Reference Texts
- `reference/im-book.txt` — An Immanent Metaphysics
- `reference/effective-choice.txt` — Aphorisms of Effective Choice
```

The agent can read these files when it needs to look something up.

## Getting Help

- **OpenClaw docs**: docs.openclaw.ai
- **OpenClaw Discord**: discord.com/invite/clawd
- **Find skills (plugins)**: clawhub.com
- **Team questions**: Message @Oren_Tillerman_Bot on Telegram (Oren, team coordinator), or email Jared at jaredclucas@gmail.com

You don't need to be technical to do this. The onboarding wizard handles the configuration. If you can install an app and paste an API key, you can run an agent. Once it's running, you just talk to it on Telegram like you would any person.
