# Financial Metrics for Israeli Stocks

## Profitability Metrics

### Gross Profit Margin
**Formula:** (Revenue - Cost of Goods Sold) / Revenue × 100%
**Interpretation:**
- Shows production efficiency and pricing power
- Higher is better; improving trend is bullish
- Varies significantly by industry
- Industrial/retail: 20-40%
- Tech/software: 60-80%
- Banks: N/A (different cost structure)

**Israeli Market Note:** Manufacturing in Israel has higher labor costs; service companies typically have higher margins.

### Operating Profit Margin (EBIT Margin)
**Formula:** (EBIT) / Revenue × 100%
**Interpretation:**
- Shows operational efficiency (before financing and taxes)
- Includes all operating expenses
- Better measure of core business performance
- Typical ranges by sector:
  - Industrial: 10-20%
  - Retail: 3-8%
  - Technology: 15-35%
  - Banks: 30-50%

### Net Profit Margin
**Formula:** (Net Income) / Revenue × 100%
**Interpretation:**
- Final profit after all expenses, taxes, and financing
- Affected by capital structure and tax rate
- Israeli corporate tax rate: ~23%
- Typical ranges:
  - Industrial: 5-15%
  - Retail: 1-5%
  - Technology: 10-25%
  - Banks: 15-30%

## Return Metrics

### Return on Equity (ROE)
**Formula:** Net Income / Average Shareholders' Equity × 100%
**Interpretation:**
- How efficiently management uses shareholder capital
- Sustainable ROE >15% is strong
- Trend matters: Improving ROE is bullish
- Affected by leverage (debt increases ROE)
- Typical Israeli market ROE by sector:
  - Banks: 8-12%
  - Insurance: 10-15%
  - Tech: 15-30%
  - Industrial: 10-20%

### Return on Invested Capital (ROIC)
**Formula:** EBIT × (1 - Tax Rate) / Invested Capital
**Interpretation:**
- Measures return on all capital (debt + equity)
- Better measure than ROE for comparing companies with different capital structures
- ROIC >10% is good; >15% is excellent
- Should exceed cost of capital for value creation

### Return on Assets (ROA)
**Formula:** Net Income / Average Total Assets × 100%
**Interpretation:**
- Asset efficiency metric
- Especially useful for financial institutions
- Banks typical ROA: 0.5-1.5%

## Valuation Multiples

### Price-to-Earnings (P/E) Ratio
**Formula:** Stock Price / Earnings Per Share
**Interpretation:**
- How many shekels investors pay per shekel of earnings
- Lower P/E may indicate undervaluation
- Higher P/E may indicate growth expectations
- TA25 average P/E: 12-15x

**Usage:**
- Compare to historical average (5-year, 10-year)
- Compare to peer group
- Adjust for growth rate (see PEG below)

### Price-to-Book (P/B) Ratio
**Formula:** Market Cap / Book Value (Shareholders' Equity)
**Interpretation:**
- Useful for financial institutions
- P/B <1 may indicate undervaluation (or financial weakness)
- P/B >3 may indicate overvaluation
- Bank sector typical P/B: 0.8-1.2x
- Insurance typical P/B: 0.8-1.3x

### Price-to-Sales (P/S) Ratio
**Formula:** Market Cap / Total Revenue
**Interpretation:**
- Less affected by accounting choices than P/E
- Lower is better; <2 is typically attractive
- Useful for comparing companies with different profitability

### PEG Ratio (Price/Earnings to Growth)
**Formula:** P/E Ratio / Expected Growth Rate (%)
**Interpretation:**
- Adjusts P/E for expected growth
- PEG <1 may indicate undervaluation
- PEG >2 may indicate overvaluation
- Useful for comparing growth stocks

### EV/EBITDA Ratio
**Formula:** Enterprise Value / EBITDA
**Interpretation:**
- Enterprise Value = Market Cap + Total Debt - Cash
- Compares total company value to operating earnings
- Less affected by capital structure than P/E
- Typical ranges: 8-15x for mature companies
- 15-30x for growth companies

### Dividend Yield
**Formula:** Annual Dividend Per Share / Stock Price × 100%
**Interpretation:**
- Cash return to shareholders
- Israeli market dividend yield typical: 2-5%
- Compare to risk-free rate (Government bonds, ~5%)
- Growing dividend is bullish signal

## Liquidity Metrics

### Current Ratio
**Formula:** Current Assets / Current Liabilities
**Interpretation:**
- Ability to pay short-term obligations
- Ratio >1.5 is generally healthy
- Ratio <1 indicates potential liquidity problems
- Too high (>3) may indicate inefficient asset utilization

### Quick Ratio (Acid-Test Ratio)
**Formula:** (Current Assets - Inventory) / Current Liabilities
**Interpretation:**
- More conservative than current ratio
- Excludes inventory (less liquid)
- Ratio >1.0 is healthy
- Better measure of liquidity crisis risk

### Working Capital
**Formula:** Current Assets - Current Liabilities
**Interpretation:**
- Absolute amount of short-term financial flexibility
- Positive is required for healthy operations
- Trend matters: Growing WC may indicate growth
- Shrinking WC may indicate financial stress

### Cash Ratio
**Formula:** (Cash + Short-term Securities) / Current Liabilities
**Interpretation:**
- Most conservative liquidity measure
- Shows immediate ability to pay obligations
- Typical range: 0.2-0.5

## Efficiency Metrics

### Asset Turnover
**Formula:** Revenue / Average Total Assets
**Interpretation:**
- How effectively assets generate revenue
- Higher is better (company uses assets efficiently)
- Varies widely by industry
- Retail/Distribution: 2-5x
- Manufacturing: 0.5-1.5x
- Banks: 0.1-0.3x

### Inventory Turnover
**Formula:** Cost of Goods Sold / Average Inventory
**Interpretation:**
- How many times inventory is sold and replaced
- Higher typically indicates better inventory management
- Varies by industry:
  - Retail: 5-10x
  - Manufacturing: 2-5x
  - FMCG: 10-20x

### Receivables Turnover
**Formula:** Revenue / Average Accounts Receivable
**Interpretation:**
- How efficiently company collects receivables
- Trend is important: Declining ratio may indicate collection problems
- Days Sales Outstanding (DSO) = 365 / Receivables Turnover
- Compare to industry standard

## Leverage & Solvency Metrics

### Debt-to-Equity Ratio
**Formula:** Total Debt / Shareholders' Equity
**Interpretation:**
- Financial leverage measure
- Ratio <1.0 is conservative; >2.0 indicates high leverage
- Safe ranges depend on industry:
  - Manufacturing: <1.0 is healthy
  - Banks: >1.0 is normal (due to deposit base)
  - Real estate: <2.0 is typical
- Israeli market: Rising shekel strength increases relative debt burden

### Debt-to-Assets Ratio
**Formula:** Total Debt / Total Assets
**Interpretation:**
- Shows what percentage of assets are financed by debt
- Lower is better (>60% indicates high leverage)
- Compare to industry norms

### Interest Coverage Ratio
**Formula:** EBIT / Interest Expense
**Interpretation:**
- Ability to cover debt interest payments from operating earnings
- Ratio >5x is healthy
- Ratio <2x indicates financial stress
- Ratio <1x means company cannot cover interest from operations

### Debt Service Coverage Ratio
**Formula:** Operating Cash Flow / (Principal Repayment + Interest)
**Interpretation:**
- Ability to service total debt from operating cash flow
- Ratio >1.25x is healthy
- Ratio <1.0 indicates inability to cover payments

## Growth Metrics

### Revenue Growth (Year-over-Year)
**Formula:** (Current Year Revenue - Prior Year Revenue) / Prior Year Revenue × 100%
**Interpretation:**
- Key growth indicator
- Israeli market average: 5-8% (including inflation)
- Tech sector: 10-20%+
- Mature industrial: 0-5%
- Trend consistency matters

### Earnings Growth
**Formula:** (Current Year EPS - Prior Year EPS) / Prior Year EPS × 100%
**Interpretation:**
- Bottom-line growth
- Should exceed or match revenue growth
- Declining earnings with growing revenue indicates margin pressure

### Free Cash Flow Growth
**Formula:** (Current Year FCF - Prior Year FCF) / Prior Year FCF × 100%
**Interpretation:**
- Most reliable growth indicator
- FCF growth typically outpaces earnings growth in quality companies
- Sustainable growth foundation

## Cash Flow Metrics

### Operating Cash Flow (OCF)
**Formula:** Net Income + Depreciation + Amortization ± Changes in Working Capital
**Interpretation:**
- Cash generated from core business operations
- Should be positive and growing
- Higher than net income indicates quality earnings

### Free Cash Flow (FCF)
**Formula:** Operating Cash Flow - Capital Expenditures
**Interpretation:**
- Cash available after maintaining/expanding asset base
- Can be used for dividends, debt repayment, buybacks
- Positive FCF is prerequisite for dividend sustainability
- FCF Yield = FCF / Market Cap

### FCF Margin
**Formula:** Free Cash Flow / Revenue × 100%
**Interpretation:**
- What percentage of revenue converts to free cash
- Higher is better; indicates cash generation efficiency
- Compare to operating margin (similar but more conservative)

### Cash Conversion Ratio
**Formula:** Operating Cash Flow / Net Income × 100%
**Interpretation:**
- Quality of earnings indicator
- Ratio >100% indicates quality earnings
- Ratio <70% indicates earnings quality concerns

## Israeli Market Context

### Shekel Impact Metrics

For exporters, evaluate:
- **Foreign Currency Revenue %:** How much revenue is from non-Israeli sources?
- **Currency Hedging:** Does company hedge currency exposure?
- **Shekel Sensitivity:** How much do earnings change with 10% shekel appreciation/depreciation?

### Tax Adjusted Metrics

Israeli tax rates:
- Corporate tax: ~23%
- Capital gains: 20-25% (for individuals)
- Dividend tax: 15-25% (depending on portfolio)
- Tech companies (Research & Development Law): May qualify for reduced rates

Adjust expected returns for Israeli tax burden when calculating valuations.

### Political/Security Risk Adjustment

During periods of elevated geopolitical risk:
- Add 2-3% additional risk premium to discount rates
- Increase downside case probability
- Evaluate customer base exposure to affected regions
- Review export markets for political stability

## Sector-Specific Metrics

### Banking Sector
- Non-Performing Loan Ratio (NPL)
- Loan-to-Deposit Ratio (LTD)
- Capital Adequacy Ratio
- Cost-to-Income Ratio
- Return on Equity (ROE): 8-12% typical

### Insurance Sector
- Loss Ratio
- Expense Ratio
- Combined Ratio (<100% is profitable)
- Return on Equity (ROE): 10-15% typical

### Real Estate/Construction
- Debt-to-Equity (sector average: <2.0)
- Return on Invested Capital (ROIC)
- Profit margin (3-8% typical)
- Dividend Yield (3-5% typical)

### High-Tech
- R&D as % of Revenue (20-40% typical)
- Gross Margin (60-80% typical)
- Customer Acquisition Cost (CAC)
- Lifetime Value (LTV) to CAC ratio
- Burn Rate (for unprofitable companies)
