# User Type Adaptations

## First-Time Test Taker (Student)

**Profile:**
- University applicant (undergrad or postgrad)
- May have studied English but never taken IELTS
- Unfamiliar with test format and timing
- Often has more flexible study time (students)

**Agent Adaptations:**
- **Format introduction:** Explain all 4 sections before diving into practice
- **Full diagnostic first:** Test all sections to establish baseline
- **Broader practice:** Cover all question types, not just weaknesses
- **Time management focus:** Many first-timers don't finish Reading
- **Mock test practice:** Simulate full exam conditions early

**Common Mistakes:**
- Spending too long on Task 1 Writing (target: 20 min)
- Not reading Listening questions before audio plays
- Changing answers in Reading when unsure (usually wrong)
- Speaking too little in Part 2 (need full 2 minutes)

**Key Questions to Ask:**
- What program/university are you targeting?
- What's your exam date?
- Have you taken any English proficiency test before?
- What's your daily study time availability?

## Retaker (Stuck at Plateau)

**Profile:**
- Has taken IELTS before but didn't reach target
- Knows the format but not improving
- Often plateaued at 6.5 needing 7.0
- May be frustrated or demoralized

**Agent Adaptations:**
- **Get previous score report:** Analyze which sections/criteria failed
- **Deep diagnosis:** Find specific patterns, not just "weak at Writing"
- **Targeted drills:** 80% practice on weak areas, 20% maintenance
- **Compare to band descriptors:** Show exactly what Band 7 requires vs Band 6
- **Fossilized error detection:** Find mistakes they make repeatedly
- **OSR recommendation:** If one section drags overall, suggest One Skill Retake

**Common Patterns:**
- Writing: CC issues (paragraph structure, linking)
- Speaking: Fluency (hesitation, fillers) or pronunciation (word stress)
- Reading: Time management (not finishing Section 3)
- Listening: Section 4 (academic lectures)

**Key Questions to Ask:**
- What was your previous score breakdown?
- Which section felt hardest?
- Have you identified specific error patterns?
- How long since your last attempt?

## Working Professional (Immigration Focus)

**Profile:**
- Needs IELTS for Canada/Australia skilled migration
- Limited study time (full-time job)
- Often needs General Training (not Academic)
- High stakes (career/life decision)

**Agent Adaptations:**
- **Confirm GT vs Academic:** Immigration typically needs GT
- **Efficient study plans:** 30-60 min daily, not hours
- **Target-specific guidance:** Exact CLB/points requirements
- **Micro-practice:** 10-15 min tasks for busy days
- **Weekend intensive:** Full mocks on weekends
- **Writing Task 1 focus:** GT letter writing (different from Academic)
- **Score-to-points calculator:** Help understand immigration implications

**Common Constraints:**
- Can only study before/after work
- Weekends are prime study time
- Need visible progress to stay motivated
- May need to retake if first attempt fails

**Key Questions to Ask:**
- Which immigration pathway? (Express Entry, 189, 190, etc.)
- What's your deadline for application?
- Do you have flexibility on exam date?
- How much daily study time realistically?

## Professional Registration (Medical/Nursing)

**Profile:**
- Doctor, nurse, pharmacist needing registration
- Very high targets (often 7.0 in all or higher)
- Writing often the hardest section
- May have strong speaking but formal writing weak

**Agent Adaptations:**
- **Verify exact requirements:** Each registration body differs (GMC, NMC, AHPRA)
- **Writing intensive:** Often the blocker section
- **OET comparison:** Some may be better suited to OET instead of IELTS
- **Professional vocabulary:** Integrate medical/nursing terms naturally
- **Speaking formality:** Professional register without being stiff

**Common Challenges:**
- Writing needs to be 7.0+ (hardest to improve quickly)
- Speaking pronunciation issues (varies by L1)
- Stress and time pressure (already working long hours)

**Key Questions to Ask:**
- Which registration body?
- What's the exact band requirement per section?
- Have you considered OET as an alternative?
- What's your current Writing estimated band?

## Parent Supporting Child

**Profile:**
- Parent monitoring/helping child prepare
- May not speak English well themselves
- Wants to track progress and ensure child is on track
- Needs simple progress reporting

**Agent Adaptations:**
- **Progress reports:** Clear summaries of where child stands
- **Study schedule creation:** Parent can enforce routine
- **Milestone tracking:** "On track" vs "needs more practice"
- **Warning signs:** Flag if child is falling behind target
- **Resource recommendations:** What books/courses to buy

**Key Questions to Ask:**
- What's the child's target score and deadline?
- How much is the child practicing independently?
- Do you want weekly progress summaries?
- Is the child doing practice tests?

## Repeat Retaker (Multiple Attempts)

**Profile:**
- Has taken IELTS 3+ times
- Still not reaching target
- May have test anxiety
- Needs significant strategy change

**Agent Adaptations:**
- **Honest assessment:** Is target realistic? (e.g., 8.0 when stuck at 6.0)
- **Complete strategy overhaul:** What they've been doing isn't working
- **Consider alternatives:** OET, PTE, different immigration pathway
- **Address test anxiety:** Practice under exam conditions repeatedly
- **Focus on ONE section:** Sometimes better to OSR repeatedly

**Difficult Conversations:**
- Some targets may not be achievable in short timeframes
- Alternative pathways may be more realistic
- More attempts ≠ better results without strategy change

**Key Questions to Ask:**
- What were your scores on each attempt?
- What did you do differently each time?
- What's the maximum time you can dedicate to prep?
- Are you open to considering alternative tests?
